<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinetDetail StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CabinetDetail
 * @subpackage Structs
 */
class CabinetDetail extends AbstractStructBase
{
    /**
     * The ActualCRFS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActualCRFS;
    /**
     * The CabinetDetailNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CabinetDetailNumber;
    /**
     * The CabinetReadyForService
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CabinetReadyForService;
    /**
     * The Coverage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Coverage;
    /**
     * The FutureCRFS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FutureCRFS;
    /**
     * The L2SID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $L2SID;
    /**
     * The RAG
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RAG;
    /**
     * Constructor method for CabinetDetail
     * @uses CabinetDetail::setActualCRFS()
     * @uses CabinetDetail::setCabinetDetailNumber()
     * @uses CabinetDetail::setCabinetReadyForService()
     * @uses CabinetDetail::setCoverage()
     * @uses CabinetDetail::setFutureCRFS()
     * @uses CabinetDetail::setL2SID()
     * @uses CabinetDetail::setRAG()
     * @param string $actualCRFS
     * @param string $cabinetDetailNumber
     * @param string $cabinetReadyForService
     * @param int $coverage
     * @param string $futureCRFS
     * @param string $l2SID
     * @param string $rAG
     */
    public function __construct($actualCRFS = null, $cabinetDetailNumber = null, $cabinetReadyForService = null, $coverage = null, $futureCRFS = null, $l2SID = null, $rAG = null)
    {
        $this
            ->setActualCRFS($actualCRFS)
            ->setCabinetDetailNumber($cabinetDetailNumber)
            ->setCabinetReadyForService($cabinetReadyForService)
            ->setCoverage($coverage)
            ->setFutureCRFS($futureCRFS)
            ->setL2SID($l2SID)
            ->setRAG($rAG);
    }
    /**
     * Get ActualCRFS value
     * @return string|null
     */
    public function getActualCRFS()
    {
        return $this->ActualCRFS;
    }
    /**
     * Set ActualCRFS value
     * @param string $actualCRFS
     * @return \StructType\CabinetDetail
     */
    public function setActualCRFS($actualCRFS = null)
    {
        // validation for constraint: string
        if (!is_null($actualCRFS) && !is_string($actualCRFS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actualCRFS)), __LINE__);
        }
        $this->ActualCRFS = $actualCRFS;
        return $this;
    }
    /**
     * Get CabinetDetailNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCabinetDetailNumber()
    {
        return isset($this->CabinetDetailNumber) ? $this->CabinetDetailNumber : null;
    }
    /**
     * Set CabinetDetailNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cabinetDetailNumber
     * @return \StructType\CabinetDetail
     */
    public function setCabinetDetailNumber($cabinetDetailNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cabinetDetailNumber) && !is_string($cabinetDetailNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cabinetDetailNumber)), __LINE__);
        }
        if (is_null($cabinetDetailNumber) || (is_array($cabinetDetailNumber) && empty($cabinetDetailNumber))) {
            unset($this->CabinetDetailNumber);
        } else {
            $this->CabinetDetailNumber = $cabinetDetailNumber;
        }
        return $this;
    }
    /**
     * Get CabinetReadyForService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCabinetReadyForService()
    {
        return isset($this->CabinetReadyForService) ? $this->CabinetReadyForService : null;
    }
    /**
     * Set CabinetReadyForService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cabinetReadyForService
     * @return \StructType\CabinetDetail
     */
    public function setCabinetReadyForService($cabinetReadyForService = null)
    {
        // validation for constraint: string
        if (!is_null($cabinetReadyForService) && !is_string($cabinetReadyForService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cabinetReadyForService)), __LINE__);
        }
        if (is_null($cabinetReadyForService) || (is_array($cabinetReadyForService) && empty($cabinetReadyForService))) {
            unset($this->CabinetReadyForService);
        } else {
            $this->CabinetReadyForService = $cabinetReadyForService;
        }
        return $this;
    }
    /**
     * Get Coverage value
     * @return int|null
     */
    public function getCoverage()
    {
        return $this->Coverage;
    }
    /**
     * Set Coverage value
     * @param int $coverage
     * @return \StructType\CabinetDetail
     */
    public function setCoverage($coverage = null)
    {
        // validation for constraint: int
        if (!is_null($coverage) && !is_numeric($coverage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($coverage)), __LINE__);
        }
        $this->Coverage = $coverage;
        return $this;
    }
    /**
     * Get FutureCRFS value
     * @return string|null
     */
    public function getFutureCRFS()
    {
        return $this->FutureCRFS;
    }
    /**
     * Set FutureCRFS value
     * @param string $futureCRFS
     * @return \StructType\CabinetDetail
     */
    public function setFutureCRFS($futureCRFS = null)
    {
        // validation for constraint: string
        if (!is_null($futureCRFS) && !is_string($futureCRFS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($futureCRFS)), __LINE__);
        }
        $this->FutureCRFS = $futureCRFS;
        return $this;
    }
    /**
     * Get L2SID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getL2SID()
    {
        return isset($this->L2SID) ? $this->L2SID : null;
    }
    /**
     * Set L2SID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $l2SID
     * @return \StructType\CabinetDetail
     */
    public function setL2SID($l2SID = null)
    {
        // validation for constraint: string
        if (!is_null($l2SID) && !is_string($l2SID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($l2SID)), __LINE__);
        }
        if (is_null($l2SID) || (is_array($l2SID) && empty($l2SID))) {
            unset($this->L2SID);
        } else {
            $this->L2SID = $l2SID;
        }
        return $this;
    }
    /**
     * Get RAG value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRAG()
    {
        return isset($this->RAG) ? $this->RAG : null;
    }
    /**
     * Set RAG value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rAG
     * @return \StructType\CabinetDetail
     */
    public function setRAG($rAG = null)
    {
        // validation for constraint: string
        if (!is_null($rAG) && !is_string($rAG)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rAG)), __LINE__);
        }
        if (is_null($rAG) || (is_array($rAG) && empty($rAG))) {
            unset($this->RAG);
        } else {
            $this->RAG = $rAG;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CabinetDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
