<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalInformation StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AdditionalInformation
 * @subpackage Structs
 */
class AdditionalInformation extends AbstractStructBase
{
    /**
     * The AdditionalInformationType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdditionalInformationType;
    /**
     * The AdditionalInformationValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdditionalInformationValue;
    /**
     * Constructor method for AdditionalInformation
     * @uses AdditionalInformation::setAdditionalInformationType()
     * @uses AdditionalInformation::setAdditionalInformationValue()
     * @param string $additionalInformationType
     * @param string $additionalInformationValue
     */
    public function __construct($additionalInformationType = null, $additionalInformationValue = null)
    {
        $this
            ->setAdditionalInformationType($additionalInformationType)
            ->setAdditionalInformationValue($additionalInformationValue);
    }
    /**
     * Get AdditionalInformationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdditionalInformationType()
    {
        return isset($this->AdditionalInformationType) ? $this->AdditionalInformationType : null;
    }
    /**
     * Set AdditionalInformationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $additionalInformationType
     * @return \StructType\AdditionalInformation
     */
    public function setAdditionalInformationType($additionalInformationType = null)
    {
        // validation for constraint: string
        if (!is_null($additionalInformationType) && !is_string($additionalInformationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($additionalInformationType)), __LINE__);
        }
        if (is_null($additionalInformationType) || (is_array($additionalInformationType) && empty($additionalInformationType))) {
            unset($this->AdditionalInformationType);
        } else {
            $this->AdditionalInformationType = $additionalInformationType;
        }
        return $this;
    }
    /**
     * Get AdditionalInformationValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdditionalInformationValue()
    {
        return isset($this->AdditionalInformationValue) ? $this->AdditionalInformationValue : null;
    }
    /**
     * Set AdditionalInformationValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $additionalInformationValue
     * @return \StructType\AdditionalInformation
     */
    public function setAdditionalInformationValue($additionalInformationValue = null)
    {
        // validation for constraint: string
        if (!is_null($additionalInformationValue) && !is_string($additionalInformationValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($additionalInformationValue)), __LINE__);
        }
        if (is_null($additionalInformationValue) || (is_array($additionalInformationValue) && empty($additionalInformationValue))) {
            unset($this->AdditionalInformationValue);
        } else {
            $this->AdditionalInformationValue = $additionalInformationValue;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
