<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ADSL2PLUSAvailabilityDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ADSL2PLUSAvailabilityDetails
 * @subpackage Structs
 */
class ADSL2PLUSAvailabilityDetails extends AbstractStructBase
{
    /**
     * The AnnexMInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WBCAnnexMAvailabilityDetails
     */
    public $AnnexMInfo;
    /**
     * The Available
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Available;
    /**
     * The CapacityDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CapacityDate;
    /**
     * The EstimatedDownstreamSpeed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EstimatedDownstreamSpeed;
    /**
     * The EstimatedMaxRange
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EstimatedMaxRange;
    /**
     * The EstimatedMinRange
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EstimatedMinRange;
    /**
     * The EstimatedThroughputSpeed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfThroughputSpeedType
     */
    public $EstimatedThroughputSpeed;
    /**
     * The ExchangeStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExchangeStatus;
    /**
     * The FixedRateCapacityDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FixedRateCapacityDate;
    /**
     * The FixedRateExchangeStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FixedRateExchangeStatus;
    /**
     * The FixedRateLineStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FixedRateLineStatus;
    /**
     * The FixedRateReadyDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FixedRateReadyDate;
    /**
     * The MinThreshold
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MinThreshold;
    /**
     * The ReadyDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReadyDate;
    /**
     * Constructor method for ADSL2PLUSAvailabilityDetails
     * @uses ADSL2PLUSAvailabilityDetails::setAnnexMInfo()
     * @uses ADSL2PLUSAvailabilityDetails::setAvailable()
     * @uses ADSL2PLUSAvailabilityDetails::setCapacityDate()
     * @uses ADSL2PLUSAvailabilityDetails::setEstimatedDownstreamSpeed()
     * @uses ADSL2PLUSAvailabilityDetails::setEstimatedMaxRange()
     * @uses ADSL2PLUSAvailabilityDetails::setEstimatedMinRange()
     * @uses ADSL2PLUSAvailabilityDetails::setEstimatedThroughputSpeed()
     * @uses ADSL2PLUSAvailabilityDetails::setExchangeStatus()
     * @uses ADSL2PLUSAvailabilityDetails::setFixedRateCapacityDate()
     * @uses ADSL2PLUSAvailabilityDetails::setFixedRateExchangeStatus()
     * @uses ADSL2PLUSAvailabilityDetails::setFixedRateLineStatus()
     * @uses ADSL2PLUSAvailabilityDetails::setFixedRateReadyDate()
     * @uses ADSL2PLUSAvailabilityDetails::setMinThreshold()
     * @uses ADSL2PLUSAvailabilityDetails::setReadyDate()
     * @param \StructType\WBCAnnexMAvailabilityDetails $annexMInfo
     * @param string $available
     * @param string $capacityDate
     * @param string $estimatedDownstreamSpeed
     * @param string $estimatedMaxRange
     * @param string $estimatedMinRange
     * @param \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeed
     * @param string $exchangeStatus
     * @param string $fixedRateCapacityDate
     * @param string $fixedRateExchangeStatus
     * @param int $fixedRateLineStatus
     * @param string $fixedRateReadyDate
     * @param string $minThreshold
     * @param string $readyDate
     */
    public function __construct(\StructType\WBCAnnexMAvailabilityDetails $annexMInfo = null, $available = null, $capacityDate = null, $estimatedDownstreamSpeed = null, $estimatedMaxRange = null, $estimatedMinRange = null, \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeed = null, $exchangeStatus = null, $fixedRateCapacityDate = null, $fixedRateExchangeStatus = null, $fixedRateLineStatus = null, $fixedRateReadyDate = null, $minThreshold = null, $readyDate = null)
    {
        $this
            ->setAnnexMInfo($annexMInfo)
            ->setAvailable($available)
            ->setCapacityDate($capacityDate)
            ->setEstimatedDownstreamSpeed($estimatedDownstreamSpeed)
            ->setEstimatedMaxRange($estimatedMaxRange)
            ->setEstimatedMinRange($estimatedMinRange)
            ->setEstimatedThroughputSpeed($estimatedThroughputSpeed)
            ->setExchangeStatus($exchangeStatus)
            ->setFixedRateCapacityDate($fixedRateCapacityDate)
            ->setFixedRateExchangeStatus($fixedRateExchangeStatus)
            ->setFixedRateLineStatus($fixedRateLineStatus)
            ->setFixedRateReadyDate($fixedRateReadyDate)
            ->setMinThreshold($minThreshold)
            ->setReadyDate($readyDate);
    }
    /**
     * Get AnnexMInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WBCAnnexMAvailabilityDetails|null
     */
    public function getAnnexMInfo()
    {
        return isset($this->AnnexMInfo) ? $this->AnnexMInfo : null;
    }
    /**
     * Set AnnexMInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WBCAnnexMAvailabilityDetails $annexMInfo
     * @return \StructType\ADSL2PLUSAvailabilityDetails
     */
    public function setAnnexMInfo(\StructType\WBCAnnexMAvailabilityDetails $annexMInfo = null)
    {
        if (is_null($annexMInfo) || (is_array($annexMInfo) && empty($annexMInfo))) {
            unset($this->AnnexMInfo);
        } else {
            $this->AnnexMInfo = $annexMInfo;
        }
        return $this;
    }
    /**
     * Get Available value
     * @return string|null
     */
    public function getAvailable()
    {
        return $this->Available;
    }
    /**
     * Set Available value
     * @uses \EnumType\YesNoEnum::valueIsValid()
     * @uses \EnumType\YesNoEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $available
     * @return \StructType\ADSL2PLUSAvailabilityDetails
     */
    public function setAvailable($available = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\YesNoEnum::valueIsValid($available)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $available, implode(', ', \EnumType\YesNoEnum::getValidValues())), __LINE__);
        }
        $this->Available = $available;
        return $this;
    }
    /**
     * Get CapacityDate value
     * @return string|null
     */
    public function getCapacityDate()
    {
        return $this->CapacityDate;
    }
    /**
     * Set CapacityDate value
     * @param string $capacityDate
     * @return \StructType\ADSL2PLUSAvailabilityDetails
     */
    public function setCapacityDate($capacityDate = null)
    {
        // validation for constraint: string
        if (!is_null($capacityDate) && !is_string($capacityDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($capacityDate)), __LINE__);
        }
        $this->CapacityDate = $capacityDate;
        return $this;
    }
    /**
     * Get EstimatedDownstreamSpeed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstimatedDownstreamSpeed()
    {
        return isset($this->EstimatedDownstreamSpeed) ? $this->EstimatedDownstreamSpeed : null;
    }
    /**
     * Set EstimatedDownstreamSpeed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estimatedDownstreamSpeed
     * @return \StructType\ADSL2PLUSAvailabilityDetails
     */
    public function setEstimatedDownstreamSpeed($estimatedDownstreamSpeed = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedDownstreamSpeed) && !is_string($estimatedDownstreamSpeed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedDownstreamSpeed)), __LINE__);
        }
        if (is_null($estimatedDownstreamSpeed) || (is_array($estimatedDownstreamSpeed) && empty($estimatedDownstreamSpeed))) {
            unset($this->EstimatedDownstreamSpeed);
        } else {
            $this->EstimatedDownstreamSpeed = $estimatedDownstreamSpeed;
        }
        return $this;
    }
    /**
     * Get EstimatedMaxRange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstimatedMaxRange()
    {
        return isset($this->EstimatedMaxRange) ? $this->EstimatedMaxRange : null;
    }
    /**
     * Set EstimatedMaxRange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estimatedMaxRange
     * @return \StructType\ADSL2PLUSAvailabilityDetails
     */
    public function setEstimatedMaxRange($estimatedMaxRange = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedMaxRange) && !is_string($estimatedMaxRange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedMaxRange)), __LINE__);
        }
        if (is_null($estimatedMaxRange) || (is_array($estimatedMaxRange) && empty($estimatedMaxRange))) {
            unset($this->EstimatedMaxRange);
        } else {
            $this->EstimatedMaxRange = $estimatedMaxRange;
        }
        return $this;
    }
    /**
     * Get EstimatedMinRange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstimatedMinRange()
    {
        return isset($this->EstimatedMinRange) ? $this->EstimatedMinRange : null;
    }
    /**
     * Set EstimatedMinRange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estimatedMinRange
     * @return \StructType\ADSL2PLUSAvailabilityDetails
     */
    public function setEstimatedMinRange($estimatedMinRange = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedMinRange) && !is_string($estimatedMinRange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedMinRange)), __LINE__);
        }
        if (is_null($estimatedMinRange) || (is_array($estimatedMinRange) && empty($estimatedMinRange))) {
            unset($this->EstimatedMinRange);
        } else {
            $this->EstimatedMinRange = $estimatedMinRange;
        }
        return $this;
    }
    /**
     * Get EstimatedThroughputSpeed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfThroughputSpeedType|null
     */
    public function getEstimatedThroughputSpeed()
    {
        return isset($this->EstimatedThroughputSpeed) ? $this->EstimatedThroughputSpeed : null;
    }
    /**
     * Set EstimatedThroughputSpeed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeed
     * @return \StructType\ADSL2PLUSAvailabilityDetails
     */
    public function setEstimatedThroughputSpeed(\ArrayType\ArrayOfThroughputSpeedType $estimatedThroughputSpeed = null)
    {
        if (is_null($estimatedThroughputSpeed) || (is_array($estimatedThroughputSpeed) && empty($estimatedThroughputSpeed))) {
            unset($this->EstimatedThroughputSpeed);
        } else {
            $this->EstimatedThroughputSpeed = $estimatedThroughputSpeed;
        }
        return $this;
    }
    /**
     * Get ExchangeStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExchangeStatus()
    {
        return isset($this->ExchangeStatus) ? $this->ExchangeStatus : null;
    }
    /**
     * Set ExchangeStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exchangeStatus
     * @return \StructType\ADSL2PLUSAvailabilityDetails
     */
    public function setExchangeStatus($exchangeStatus = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeStatus) && !is_string($exchangeStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exchangeStatus)), __LINE__);
        }
        if (is_null($exchangeStatus) || (is_array($exchangeStatus) && empty($exchangeStatus))) {
            unset($this->ExchangeStatus);
        } else {
            $this->ExchangeStatus = $exchangeStatus;
        }
        return $this;
    }
    /**
     * Get FixedRateCapacityDate value
     * @return string|null
     */
    public function getFixedRateCapacityDate()
    {
        return $this->FixedRateCapacityDate;
    }
    /**
     * Set FixedRateCapacityDate value
     * @param string $fixedRateCapacityDate
     * @return \StructType\ADSL2PLUSAvailabilityDetails
     */
    public function setFixedRateCapacityDate($fixedRateCapacityDate = null)
    {
        // validation for constraint: string
        if (!is_null($fixedRateCapacityDate) && !is_string($fixedRateCapacityDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fixedRateCapacityDate)), __LINE__);
        }
        $this->FixedRateCapacityDate = $fixedRateCapacityDate;
        return $this;
    }
    /**
     * Get FixedRateExchangeStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFixedRateExchangeStatus()
    {
        return isset($this->FixedRateExchangeStatus) ? $this->FixedRateExchangeStatus : null;
    }
    /**
     * Set FixedRateExchangeStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fixedRateExchangeStatus
     * @return \StructType\ADSL2PLUSAvailabilityDetails
     */
    public function setFixedRateExchangeStatus($fixedRateExchangeStatus = null)
    {
        // validation for constraint: string
        if (!is_null($fixedRateExchangeStatus) && !is_string($fixedRateExchangeStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fixedRateExchangeStatus)), __LINE__);
        }
        if (is_null($fixedRateExchangeStatus) || (is_array($fixedRateExchangeStatus) && empty($fixedRateExchangeStatus))) {
            unset($this->FixedRateExchangeStatus);
        } else {
            $this->FixedRateExchangeStatus = $fixedRateExchangeStatus;
        }
        return $this;
    }
    /**
     * Get FixedRateLineStatus value
     * @return int|null
     */
    public function getFixedRateLineStatus()
    {
        return $this->FixedRateLineStatus;
    }
    /**
     * Set FixedRateLineStatus value
     * @param int $fixedRateLineStatus
     * @return \StructType\ADSL2PLUSAvailabilityDetails
     */
    public function setFixedRateLineStatus($fixedRateLineStatus = null)
    {
        // validation for constraint: int
        if (!is_null($fixedRateLineStatus) && !is_numeric($fixedRateLineStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fixedRateLineStatus)), __LINE__);
        }
        $this->FixedRateLineStatus = $fixedRateLineStatus;
        return $this;
    }
    /**
     * Get FixedRateReadyDate value
     * @return string|null
     */
    public function getFixedRateReadyDate()
    {
        return $this->FixedRateReadyDate;
    }
    /**
     * Set FixedRateReadyDate value
     * @param string $fixedRateReadyDate
     * @return \StructType\ADSL2PLUSAvailabilityDetails
     */
    public function setFixedRateReadyDate($fixedRateReadyDate = null)
    {
        // validation for constraint: string
        if (!is_null($fixedRateReadyDate) && !is_string($fixedRateReadyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fixedRateReadyDate)), __LINE__);
        }
        $this->FixedRateReadyDate = $fixedRateReadyDate;
        return $this;
    }
    /**
     * Get MinThreshold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMinThreshold()
    {
        return isset($this->MinThreshold) ? $this->MinThreshold : null;
    }
    /**
     * Set MinThreshold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $minThreshold
     * @return \StructType\ADSL2PLUSAvailabilityDetails
     */
    public function setMinThreshold($minThreshold = null)
    {
        // validation for constraint: string
        if (!is_null($minThreshold) && !is_string($minThreshold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minThreshold)), __LINE__);
        }
        if (is_null($minThreshold) || (is_array($minThreshold) && empty($minThreshold))) {
            unset($this->MinThreshold);
        } else {
            $this->MinThreshold = $minThreshold;
        }
        return $this;
    }
    /**
     * Get ReadyDate value
     * @return string|null
     */
    public function getReadyDate()
    {
        return $this->ReadyDate;
    }
    /**
     * Set ReadyDate value
     * @param string $readyDate
     * @return \StructType\ADSL2PLUSAvailabilityDetails
     */
    public function setReadyDate($readyDate = null)
    {
        // validation for constraint: string
        if (!is_null($readyDate) && !is_string($readyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($readyDate)), __LINE__);
        }
        $this->ReadyDate = $readyDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ADSL2PLUSAvailabilityDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
