<?php

namespace EnumType;

/**
 * This class stands for LLUExchangeStateEnum EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LLUExchangeStateEnum
 * @subpackage Enumerations
 */
class LLUExchangeStateEnum
{
    /**
     * Constant for value 'NotSet'
     * @return string 'NotSet'
     */
    const VALUE_NOT_SET = 'NotSet';
    /**
     * Constant for value 'Unplanned'
     * @return string 'Unplanned'
     */
    const VALUE_UNPLANNED = 'Unplanned';
    /**
     * Constant for value 'Targeted'
     * @return string 'Targeted'
     */
    const VALUE_TARGETED = 'Targeted';
    /**
     * Constant for value 'Scheduled'
     * @return string 'Scheduled'
     */
    const VALUE_SCHEDULED = 'Scheduled';
    /**
     * Constant for value 'Unbundling'
     * @return string 'Unbundling'
     */
    const VALUE_UNBUNDLING = 'Unbundling';
    /**
     * Constant for value 'Completing'
     * @return string 'Completing'
     */
    const VALUE_COMPLETING = 'Completing';
    /**
     * Constant for value 'Live'
     * @return string 'Live'
     */
    const VALUE_LIVE = 'Live';
    /**
     * Constant for value 'LiveTU'
     * @return string 'LiveTU'
     */
    const VALUE_LIVE_TU = 'LiveTU';
    /**
     * Constant for value 'Suspended'
     * @return string 'Suspended'
     */
    const VALUE_SUSPENDED = 'Suspended';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SET
     * @uses self::VALUE_UNPLANNED
     * @uses self::VALUE_TARGETED
     * @uses self::VALUE_SCHEDULED
     * @uses self::VALUE_UNBUNDLING
     * @uses self::VALUE_COMPLETING
     * @uses self::VALUE_LIVE
     * @uses self::VALUE_LIVE_TU
     * @uses self::VALUE_SUSPENDED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SET,
            self::VALUE_UNPLANNED,
            self::VALUE_TARGETED,
            self::VALUE_SCHEDULED,
            self::VALUE_UNBUNDLING,
            self::VALUE_COMPLETING,
            self::VALUE_LIVE,
            self::VALUE_LIVE_TU,
            self::VALUE_SUSPENDED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
