<?php

namespace EnumType;

/**
 * This class stands for FutureResilienceLevelEnum EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:FutureResilienceLevelEnum
 * @subpackage Enumerations
 */
class FutureResilienceLevelEnum
{
    /**
     * Constant for value 'Level_1'
     * @return string 'Level_1'
     */
    const VALUE_LEVEL_1 = 'Level_1';
    /**
     * Constant for value 'Level_2'
     * @return string 'Level_2'
     */
    const VALUE_LEVEL_2 = 'Level_2';
    /**
     * Constant for value 'Level_3'
     * @return string 'Level_3'
     */
    const VALUE_LEVEL_3 = 'Level_3';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LEVEL_1
     * @uses self::VALUE_LEVEL_2
     * @uses self::VALUE_LEVEL_3
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LEVEL_1,
            self::VALUE_LEVEL_2,
            self::VALUE_LEVEL_3,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
