<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfServiceInfo ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfServiceInfo
 * @subpackage Arrays
 */
class ArrayOfServiceInfo extends AbstractStructArrayBase
{
    /**
     * The ServiceInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceInfo[]
     */
    public $ServiceInfo;
    /**
     * Constructor method for ArrayOfServiceInfo
     * @uses ArrayOfServiceInfo::setServiceInfo()
     * @param \StructType\ServiceInfo[] $serviceInfo
     */
    public function __construct(array $serviceInfo = array())
    {
        $this
            ->setServiceInfo($serviceInfo);
    }
    /**
     * Get ServiceInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceInfo[]|null
     */
    public function getServiceInfo()
    {
        return isset($this->ServiceInfo) ? $this->ServiceInfo : null;
    }
    /**
     * Set ServiceInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceInfo[] $serviceInfo
     * @return \ArrayType\ArrayOfServiceInfo
     */
    public function setServiceInfo(array $serviceInfo = array())
    {
        foreach ($serviceInfo as $arrayOfServiceInfoServiceInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfServiceInfoServiceInfoItem instanceof \StructType\ServiceInfo) {
                throw new \InvalidArgumentException(sprintf('The ServiceInfo property can only contain items of \StructType\ServiceInfo, "%s" given', is_object($arrayOfServiceInfoServiceInfoItem) ? get_class($arrayOfServiceInfoServiceInfoItem) : gettype($arrayOfServiceInfoServiceInfoItem)), __LINE__);
            }
        }
        if (is_null($serviceInfo) || (is_array($serviceInfo) && empty($serviceInfo))) {
            unset($this->ServiceInfo);
        } else {
            $this->ServiceInfo = $serviceInfo;
        }
        return $this;
    }
    /**
     * Add item to ServiceInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceInfo $item
     * @return \ArrayType\ArrayOfServiceInfo
     */
    public function addToServiceInfo(\StructType\ServiceInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceInfo) {
            throw new \InvalidArgumentException(sprintf('The ServiceInfo property can only contain items of \StructType\ServiceInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ServiceInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ServiceInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ServiceInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ServiceInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ServiceInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ServiceInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServiceInfo
     */
    public function getAttributeName()
    {
        return 'ServiceInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfServiceInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
