<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOpenOrderInfo ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfOpenOrderInfo
 * @subpackage Arrays
 */
class ArrayOfOpenOrderInfo extends AbstractStructArrayBase
{
    /**
     * The OpenOrderInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OpenOrderInfo[]
     */
    public $OpenOrderInfo;
    /**
     * Constructor method for ArrayOfOpenOrderInfo
     * @uses ArrayOfOpenOrderInfo::setOpenOrderInfo()
     * @param \StructType\OpenOrderInfo[] $openOrderInfo
     */
    public function __construct(array $openOrderInfo = array())
    {
        $this
            ->setOpenOrderInfo($openOrderInfo);
    }
    /**
     * Get OpenOrderInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OpenOrderInfo[]|null
     */
    public function getOpenOrderInfo()
    {
        return isset($this->OpenOrderInfo) ? $this->OpenOrderInfo : null;
    }
    /**
     * Set OpenOrderInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OpenOrderInfo[] $openOrderInfo
     * @return \ArrayType\ArrayOfOpenOrderInfo
     */
    public function setOpenOrderInfo(array $openOrderInfo = array())
    {
        foreach ($openOrderInfo as $arrayOfOpenOrderInfoOpenOrderInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfOpenOrderInfoOpenOrderInfoItem instanceof \StructType\OpenOrderInfo) {
                throw new \InvalidArgumentException(sprintf('The OpenOrderInfo property can only contain items of \StructType\OpenOrderInfo, "%s" given', is_object($arrayOfOpenOrderInfoOpenOrderInfoItem) ? get_class($arrayOfOpenOrderInfoOpenOrderInfoItem) : gettype($arrayOfOpenOrderInfoOpenOrderInfoItem)), __LINE__);
            }
        }
        if (is_null($openOrderInfo) || (is_array($openOrderInfo) && empty($openOrderInfo))) {
            unset($this->OpenOrderInfo);
        } else {
            $this->OpenOrderInfo = $openOrderInfo;
        }
        return $this;
    }
    /**
     * Add item to OpenOrderInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\OpenOrderInfo $item
     * @return \ArrayType\ArrayOfOpenOrderInfo
     */
    public function addToOpenOrderInfo(\StructType\OpenOrderInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OpenOrderInfo) {
            throw new \InvalidArgumentException(sprintf('The OpenOrderInfo property can only contain items of \StructType\OpenOrderInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OpenOrderInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OpenOrderInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OpenOrderInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OpenOrderInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OpenOrderInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OpenOrderInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OpenOrderInfo
     */
    public function getAttributeName()
    {
        return 'OpenOrderInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfOpenOrderInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
