<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Value StructType
 * @subpackage Structs
 */
class Value extends AbstractStructBase
{
    /**
     * The codeValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codeValue;
    /**
     * The numericalvalue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $numericalvalue;
    /**
     * Constructor method for Value
     * @uses Value::setCodeValue()
     * @uses Value::setNumericalvalue()
     * @param string $codeValue
     * @param float $numericalvalue
     */
    public function __construct($codeValue = null, $numericalvalue = null)
    {
        $this
            ->setCodeValue($codeValue)
            ->setNumericalvalue($numericalvalue);
    }
    /**
     * Get codeValue value
     * @return string|null
     */
    public function getCodeValue()
    {
        return $this->codeValue;
    }
    /**
     * Set codeValue value
     * @param string $codeValue
     * @return \StructType\Value
     */
    public function setCodeValue($codeValue = null)
    {
        // validation for constraint: string
        if (!is_null($codeValue) && !is_string($codeValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeValue)), __LINE__);
        }
        $this->codeValue = $codeValue;
        return $this;
    }
    /**
     * Get numericalvalue value
     * @return float|null
     */
    public function getNumericalvalue()
    {
        return $this->numericalvalue;
    }
    /**
     * Set numericalvalue value
     * @param float $numericalvalue
     * @return \StructType\Value
     */
    public function setNumericalvalue($numericalvalue = null)
    {
        $this->numericalvalue = $numericalvalue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Value
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
