<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Report StructType
 * @subpackage Structs
 */
class Report extends AbstractStructBase
{
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Message[]
     */
    public $message;
    /**
     * The valid
     * @var bool
     */
    public $valid;
    /**
     * Constructor method for Report
     * @uses Report::setMessage()
     * @uses Report::setValid()
     * @param \StructType\Message[] $message
     * @param bool $valid
     */
    public function __construct(array $message = array(), $valid = null)
    {
        $this
            ->setMessage($message)
            ->setValid($valid);
    }
    /**
     * Get message value
     * @return \StructType\Message[]|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @throws \InvalidArgumentException
     * @param \StructType\Message[] $message
     * @return \StructType\Report
     */
    public function setMessage(array $message = array())
    {
        foreach ($message as $reportMessageItem) {
            // validation for constraint: itemType
            if (!$reportMessageItem instanceof \StructType\Message) {
                throw new \InvalidArgumentException(sprintf('The message property can only contain items of \StructType\Message, "%s" given', is_object($reportMessageItem) ? get_class($reportMessageItem) : gettype($reportMessageItem)), __LINE__);
            }
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Add item to message value
     * @throws \InvalidArgumentException
     * @param \StructType\Message $item
     * @return \StructType\Report
     */
    public function addToMessage(\StructType\Message $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Message) {
            throw new \InvalidArgumentException(sprintf('The message property can only contain items of \StructType\Message, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->message[] = $item;
        return $this;
    }
    /**
     * Get valid value
     * @return bool|null
     */
    public function getValid()
    {
        return $this->valid;
    }
    /**
     * Set valid value
     * @param bool $valid
     * @return \StructType\Report
     */
    public function setValid($valid = null)
    {
        // validation for constraint: boolean
        if (!is_null($valid) && !is_bool($valid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($valid)), __LINE__);
        }
        $this->valid = $valid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Report
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
