<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuotationIssueReport StructType
 * @subpackage Structs
 */
class QuotationIssueReport extends AbstractStructBase
{
    /**
     * The quotationCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $quotationCode;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The pendency
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Pendency[]
     */
    public $pendency;
    /**
     * The report
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Report
     */
    public $report;
    /**
     * Constructor method for QuotationIssueReport
     * @uses QuotationIssueReport::setQuotationCode()
     * @uses QuotationIssueReport::setStatus()
     * @uses QuotationIssueReport::setPendency()
     * @uses QuotationIssueReport::setReport()
     * @param string $quotationCode
     * @param string $status
     * @param \StructType\Pendency[] $pendency
     * @param \StructType\Report $report
     */
    public function __construct($quotationCode = null, $status = null, array $pendency = array(), \StructType\Report $report = null)
    {
        $this
            ->setQuotationCode($quotationCode)
            ->setStatus($status)
            ->setPendency($pendency)
            ->setReport($report);
    }
    /**
     * Get quotationCode value
     * @return string|null
     */
    public function getQuotationCode()
    {
        return $this->quotationCode;
    }
    /**
     * Set quotationCode value
     * @param string $quotationCode
     * @return \StructType\QuotationIssueReport
     */
    public function setQuotationCode($quotationCode = null)
    {
        // validation for constraint: string
        if (!is_null($quotationCode) && !is_string($quotationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quotationCode)), __LINE__);
        }
        $this->quotationCode = $quotationCode;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\QuotationIssueReport
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get pendency value
     * @return \StructType\Pendency[]|null
     */
    public function getPendency()
    {
        return $this->pendency;
    }
    /**
     * Set pendency value
     * @throws \InvalidArgumentException
     * @param \StructType\Pendency[] $pendency
     * @return \StructType\QuotationIssueReport
     */
    public function setPendency(array $pendency = array())
    {
        foreach ($pendency as $quotationIssueReportPendencyItem) {
            // validation for constraint: itemType
            if (!$quotationIssueReportPendencyItem instanceof \StructType\Pendency) {
                throw new \InvalidArgumentException(sprintf('The pendency property can only contain items of \StructType\Pendency, "%s" given', is_object($quotationIssueReportPendencyItem) ? get_class($quotationIssueReportPendencyItem) : gettype($quotationIssueReportPendencyItem)), __LINE__);
            }
        }
        $this->pendency = $pendency;
        return $this;
    }
    /**
     * Add item to pendency value
     * @throws \InvalidArgumentException
     * @param \StructType\Pendency $item
     * @return \StructType\QuotationIssueReport
     */
    public function addToPendency(\StructType\Pendency $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Pendency) {
            throw new \InvalidArgumentException(sprintf('The pendency property can only contain items of \StructType\Pendency, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->pendency[] = $item;
        return $this;
    }
    /**
     * Get report value
     * @return \StructType\Report|null
     */
    public function getReport()
    {
        return $this->report;
    }
    /**
     * Set report value
     * @param \StructType\Report $report
     * @return \StructType\QuotationIssueReport
     */
    public function setReport(\StructType\Report $report = null)
    {
        $this->report = $report;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QuotationIssueReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
