<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Quotation StructType
 * @subpackage Structs
 */
class Quotation extends AbstractStructBase
{
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * The pack
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Pack
     */
    public $pack;
    /**
     * The diasPaymentCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $diasPaymentCode;
    /**
     * The distChannelCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $distChannelCode;
    /**
     * The duration
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $duration;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The endorsementCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endorsementCode;
    /**
     * The expired
     * @var bool
     */
    public $expired;
    /**
     * The insuranceEndDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insuranceEndDate;
    /**
     * The insuranceStartDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insuranceStartDate;
    /**
     * The oldPolicyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $oldPolicyCode;
    /**
     * The policyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyCode;
    /**
     * The policyHolder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Person
     */
    public $policyHolder;
    /**
     * The quotationStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $quotationStatus;
    /**
     * The source
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The subExternalCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subExternalCode;
    /**
     * The submittedStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StatusDto
     */
    public $submittedStatus;
    /**
     * The totalPremium
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TotalPremium
     */
    public $totalPremium;
    /**
     * Constructor method for Quotation
     * @uses Quotation::setCode()
     * @uses Quotation::setPack()
     * @uses Quotation::setDiasPaymentCode()
     * @uses Quotation::setDistChannelCode()
     * @uses Quotation::setDuration()
     * @uses Quotation::setEndDate()
     * @uses Quotation::setEndorsementCode()
     * @uses Quotation::setExpired()
     * @uses Quotation::setInsuranceEndDate()
     * @uses Quotation::setInsuranceStartDate()
     * @uses Quotation::setOldPolicyCode()
     * @uses Quotation::setPolicyCode()
     * @uses Quotation::setPolicyHolder()
     * @uses Quotation::setQuotationStatus()
     * @uses Quotation::setSource()
     * @uses Quotation::setStartDate()
     * @uses Quotation::setStatus()
     * @uses Quotation::setSubExternalCode()
     * @uses Quotation::setSubmittedStatus()
     * @uses Quotation::setTotalPremium()
     * @param string $code
     * @param \StructType\Pack $pack
     * @param string $diasPaymentCode
     * @param string $distChannelCode
     * @param int $duration
     * @param string $endDate
     * @param string $endorsementCode
     * @param bool $expired
     * @param string $insuranceEndDate
     * @param string $insuranceStartDate
     * @param string $oldPolicyCode
     * @param string $policyCode
     * @param \StructType\Person $policyHolder
     * @param string $quotationStatus
     * @param string $source
     * @param string $startDate
     * @param string $status
     * @param string $subExternalCode
     * @param \StructType\StatusDto $submittedStatus
     * @param \StructType\TotalPremium $totalPremium
     */
    public function __construct($code = null, \StructType\Pack $pack = null, $diasPaymentCode = null, $distChannelCode = null, $duration = null, $endDate = null, $endorsementCode = null, $expired = null, $insuranceEndDate = null, $insuranceStartDate = null, $oldPolicyCode = null, $policyCode = null, \StructType\Person $policyHolder = null, $quotationStatus = null, $source = null, $startDate = null, $status = null, $subExternalCode = null, \StructType\StatusDto $submittedStatus = null, \StructType\TotalPremium $totalPremium = null)
    {
        $this
            ->setCode($code)
            ->setPack($pack)
            ->setDiasPaymentCode($diasPaymentCode)
            ->setDistChannelCode($distChannelCode)
            ->setDuration($duration)
            ->setEndDate($endDate)
            ->setEndorsementCode($endorsementCode)
            ->setExpired($expired)
            ->setInsuranceEndDate($insuranceEndDate)
            ->setInsuranceStartDate($insuranceStartDate)
            ->setOldPolicyCode($oldPolicyCode)
            ->setPolicyCode($policyCode)
            ->setPolicyHolder($policyHolder)
            ->setQuotationStatus($quotationStatus)
            ->setSource($source)
            ->setStartDate($startDate)
            ->setStatus($status)
            ->setSubExternalCode($subExternalCode)
            ->setSubmittedStatus($submittedStatus)
            ->setTotalPremium($totalPremium);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\Quotation
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get pack value
     * @return \StructType\Pack|null
     */
    public function getPack()
    {
        return $this->pack;
    }
    /**
     * Set pack value
     * @param \StructType\Pack $pack
     * @return \StructType\Quotation
     */
    public function setPack(\StructType\Pack $pack = null)
    {
        $this->pack = $pack;
        return $this;
    }
    /**
     * Get diasPaymentCode value
     * @return string|null
     */
    public function getDiasPaymentCode()
    {
        return $this->diasPaymentCode;
    }
    /**
     * Set diasPaymentCode value
     * @param string $diasPaymentCode
     * @return \StructType\Quotation
     */
    public function setDiasPaymentCode($diasPaymentCode = null)
    {
        // validation for constraint: string
        if (!is_null($diasPaymentCode) && !is_string($diasPaymentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($diasPaymentCode)), __LINE__);
        }
        $this->diasPaymentCode = $diasPaymentCode;
        return $this;
    }
    /**
     * Get distChannelCode value
     * @return string|null
     */
    public function getDistChannelCode()
    {
        return $this->distChannelCode;
    }
    /**
     * Set distChannelCode value
     * @param string $distChannelCode
     * @return \StructType\Quotation
     */
    public function setDistChannelCode($distChannelCode = null)
    {
        // validation for constraint: string
        if (!is_null($distChannelCode) && !is_string($distChannelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distChannelCode)), __LINE__);
        }
        $this->distChannelCode = $distChannelCode;
        return $this;
    }
    /**
     * Get duration value
     * @return int|null
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @param int $duration
     * @return \StructType\Quotation
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !is_numeric($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($duration)), __LINE__);
        }
        $this->duration = $duration;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\Quotation
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get endorsementCode value
     * @return string|null
     */
    public function getEndorsementCode()
    {
        return $this->endorsementCode;
    }
    /**
     * Set endorsementCode value
     * @param string $endorsementCode
     * @return \StructType\Quotation
     */
    public function setEndorsementCode($endorsementCode = null)
    {
        // validation for constraint: string
        if (!is_null($endorsementCode) && !is_string($endorsementCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endorsementCode)), __LINE__);
        }
        $this->endorsementCode = $endorsementCode;
        return $this;
    }
    /**
     * Get expired value
     * @return bool|null
     */
    public function getExpired()
    {
        return $this->expired;
    }
    /**
     * Set expired value
     * @param bool $expired
     * @return \StructType\Quotation
     */
    public function setExpired($expired = null)
    {
        // validation for constraint: boolean
        if (!is_null($expired) && !is_bool($expired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($expired)), __LINE__);
        }
        $this->expired = $expired;
        return $this;
    }
    /**
     * Get insuranceEndDate value
     * @return string|null
     */
    public function getInsuranceEndDate()
    {
        return $this->insuranceEndDate;
    }
    /**
     * Set insuranceEndDate value
     * @param string $insuranceEndDate
     * @return \StructType\Quotation
     */
    public function setInsuranceEndDate($insuranceEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($insuranceEndDate) && !is_string($insuranceEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($insuranceEndDate)), __LINE__);
        }
        $this->insuranceEndDate = $insuranceEndDate;
        return $this;
    }
    /**
     * Get insuranceStartDate value
     * @return string|null
     */
    public function getInsuranceStartDate()
    {
        return $this->insuranceStartDate;
    }
    /**
     * Set insuranceStartDate value
     * @param string $insuranceStartDate
     * @return \StructType\Quotation
     */
    public function setInsuranceStartDate($insuranceStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($insuranceStartDate) && !is_string($insuranceStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($insuranceStartDate)), __LINE__);
        }
        $this->insuranceStartDate = $insuranceStartDate;
        return $this;
    }
    /**
     * Get oldPolicyCode value
     * @return string|null
     */
    public function getOldPolicyCode()
    {
        return $this->oldPolicyCode;
    }
    /**
     * Set oldPolicyCode value
     * @param string $oldPolicyCode
     * @return \StructType\Quotation
     */
    public function setOldPolicyCode($oldPolicyCode = null)
    {
        // validation for constraint: string
        if (!is_null($oldPolicyCode) && !is_string($oldPolicyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oldPolicyCode)), __LINE__);
        }
        $this->oldPolicyCode = $oldPolicyCode;
        return $this;
    }
    /**
     * Get policyCode value
     * @return string|null
     */
    public function getPolicyCode()
    {
        return $this->policyCode;
    }
    /**
     * Set policyCode value
     * @param string $policyCode
     * @return \StructType\Quotation
     */
    public function setPolicyCode($policyCode = null)
    {
        // validation for constraint: string
        if (!is_null($policyCode) && !is_string($policyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($policyCode)), __LINE__);
        }
        $this->policyCode = $policyCode;
        return $this;
    }
    /**
     * Get policyHolder value
     * @return \StructType\Person|null
     */
    public function getPolicyHolder()
    {
        return $this->policyHolder;
    }
    /**
     * Set policyHolder value
     * @param \StructType\Person $policyHolder
     * @return \StructType\Quotation
     */
    public function setPolicyHolder(\StructType\Person $policyHolder = null)
    {
        $this->policyHolder = $policyHolder;
        return $this;
    }
    /**
     * Get quotationStatus value
     * @return string|null
     */
    public function getQuotationStatus()
    {
        return $this->quotationStatus;
    }
    /**
     * Set quotationStatus value
     * @param string $quotationStatus
     * @return \StructType\Quotation
     */
    public function setQuotationStatus($quotationStatus = null)
    {
        // validation for constraint: string
        if (!is_null($quotationStatus) && !is_string($quotationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quotationStatus)), __LINE__);
        }
        $this->quotationStatus = $quotationStatus;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \StructType\Quotation
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\Quotation
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\Quotation
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get subExternalCode value
     * @return string|null
     */
    public function getSubExternalCode()
    {
        return $this->subExternalCode;
    }
    /**
     * Set subExternalCode value
     * @param string $subExternalCode
     * @return \StructType\Quotation
     */
    public function setSubExternalCode($subExternalCode = null)
    {
        // validation for constraint: string
        if (!is_null($subExternalCode) && !is_string($subExternalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subExternalCode)), __LINE__);
        }
        $this->subExternalCode = $subExternalCode;
        return $this;
    }
    /**
     * Get submittedStatus value
     * @return \StructType\StatusDto|null
     */
    public function getSubmittedStatus()
    {
        return $this->submittedStatus;
    }
    /**
     * Set submittedStatus value
     * @param \StructType\StatusDto $submittedStatus
     * @return \StructType\Quotation
     */
    public function setSubmittedStatus(\StructType\StatusDto $submittedStatus = null)
    {
        $this->submittedStatus = $submittedStatus;
        return $this;
    }
    /**
     * Get totalPremium value
     * @return \StructType\TotalPremium|null
     */
    public function getTotalPremium()
    {
        return $this->totalPremium;
    }
    /**
     * Set totalPremium value
     * @param \StructType\TotalPremium $totalPremium
     * @return \StructType\Quotation
     */
    public function setTotalPremium(\StructType\TotalPremium $totalPremium = null)
    {
        $this->totalPremium = $totalPremium;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Quotation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
