<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pack StructType
 * @subpackage Structs
 */
class Pack extends AbstractStructBase
{
    /**
     * The cover
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Cover[]
     */
    public $cover;
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * Constructor method for Pack
     * @uses Pack::setCover()
     * @uses Pack::setCode()
     * @param \StructType\Cover[] $cover
     * @param string $code
     */
    public function __construct(array $cover = array(), $code = null)
    {
        $this
            ->setCover($cover)
            ->setCode($code);
    }
    /**
     * Get cover value
     * @return \StructType\Cover[]|null
     */
    public function getCover()
    {
        return $this->cover;
    }
    /**
     * Set cover value
     * @throws \InvalidArgumentException
     * @param \StructType\Cover[] $cover
     * @return \StructType\Pack
     */
    public function setCover(array $cover = array())
    {
        foreach ($cover as $packCoverItem) {
            // validation for constraint: itemType
            if (!$packCoverItem instanceof \StructType\Cover) {
                throw new \InvalidArgumentException(sprintf('The cover property can only contain items of \StructType\Cover, "%s" given', is_object($packCoverItem) ? get_class($packCoverItem) : gettype($packCoverItem)), __LINE__);
            }
        }
        $this->cover = $cover;
        return $this;
    }
    /**
     * Add item to cover value
     * @throws \InvalidArgumentException
     * @param \StructType\Cover $item
     * @return \StructType\Pack
     */
    public function addToCover(\StructType\Cover $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Cover) {
            throw new \InvalidArgumentException(sprintf('The cover property can only contain items of \StructType\Cover, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->cover[] = $item;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\Pack
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Pack
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
