<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MotorInsurable StructType
 * @subpackage Structs
 */
class MotorInsurable extends Insurable
{
    /**
     * The bonusClassCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bonusClassCode;
    /**
     * The cc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $cc;
    /**
     * The driver
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Person
     */
    public $driver;
    /**
     * The eurotaxCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $eurotaxCode;
    /**
     * The manufacturerYear
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $manufacturerYear;
    /**
     * The marketValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $marketValue;
    /**
     * The motorMakeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $motorMakeCode;
    /**
     * The motorUseCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $motorUseCode;
    /**
     * The noOfClaims
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $noOfClaims;
    /**
     * The plateNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $plateNo;
    /**
     * The protectionMeasures
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $protectionMeasures;
    /**
     * The provinceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $provinceCode;
    /**
     * The purchasedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $purchasedDate;
    /**
     * The taxHp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $taxHp;
    /**
     * Constructor method for MotorInsurable
     * @uses MotorInsurable::setBonusClassCode()
     * @uses MotorInsurable::setCc()
     * @uses MotorInsurable::setDriver()
     * @uses MotorInsurable::setEurotaxCode()
     * @uses MotorInsurable::setManufacturerYear()
     * @uses MotorInsurable::setMarketValue()
     * @uses MotorInsurable::setMotorMakeCode()
     * @uses MotorInsurable::setMotorUseCode()
     * @uses MotorInsurable::setNoOfClaims()
     * @uses MotorInsurable::setPlateNo()
     * @uses MotorInsurable::setProtectionMeasures()
     * @uses MotorInsurable::setProvinceCode()
     * @uses MotorInsurable::setPurchasedDate()
     * @uses MotorInsurable::setTaxHp()
     * @param string $bonusClassCode
     * @param int $cc
     * @param \StructType\Person $driver
     * @param string $eurotaxCode
     * @param int $manufacturerYear
     * @param float $marketValue
     * @param string $motorMakeCode
     * @param string $motorUseCode
     * @param int $noOfClaims
     * @param string $plateNo
     * @param string[] $protectionMeasures
     * @param string $provinceCode
     * @param string $purchasedDate
     * @param int $taxHp
     */
    public function __construct($bonusClassCode = null, $cc = null, \StructType\Person $driver = null, $eurotaxCode = null, $manufacturerYear = null, $marketValue = null, $motorMakeCode = null, $motorUseCode = null, $noOfClaims = null, $plateNo = null, array $protectionMeasures = array(), $provinceCode = null, $purchasedDate = null, $taxHp = null)
    {
        $this
            ->setBonusClassCode($bonusClassCode)
            ->setCc($cc)
            ->setDriver($driver)
            ->setEurotaxCode($eurotaxCode)
            ->setManufacturerYear($manufacturerYear)
            ->setMarketValue($marketValue)
            ->setMotorMakeCode($motorMakeCode)
            ->setMotorUseCode($motorUseCode)
            ->setNoOfClaims($noOfClaims)
            ->setPlateNo($plateNo)
            ->setProtectionMeasures($protectionMeasures)
            ->setProvinceCode($provinceCode)
            ->setPurchasedDate($purchasedDate)
            ->setTaxHp($taxHp);
    }
    /**
     * Get bonusClassCode value
     * @return string|null
     */
    public function getBonusClassCode()
    {
        return $this->bonusClassCode;
    }
    /**
     * Set bonusClassCode value
     * @param string $bonusClassCode
     * @return \StructType\MotorInsurable
     */
    public function setBonusClassCode($bonusClassCode = null)
    {
        // validation for constraint: string
        if (!is_null($bonusClassCode) && !is_string($bonusClassCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bonusClassCode)), __LINE__);
        }
        $this->bonusClassCode = $bonusClassCode;
        return $this;
    }
    /**
     * Get cc value
     * @return int|null
     */
    public function getCc()
    {
        return $this->cc;
    }
    /**
     * Set cc value
     * @param int $cc
     * @return \StructType\MotorInsurable
     */
    public function setCc($cc = null)
    {
        // validation for constraint: int
        if (!is_null($cc) && !is_numeric($cc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cc)), __LINE__);
        }
        $this->cc = $cc;
        return $this;
    }
    /**
     * Get driver value
     * @return \StructType\Person|null
     */
    public function getDriver()
    {
        return $this->driver;
    }
    /**
     * Set driver value
     * @param \StructType\Person $driver
     * @return \StructType\MotorInsurable
     */
    public function setDriver(\StructType\Person $driver = null)
    {
        $this->driver = $driver;
        return $this;
    }
    /**
     * Get eurotaxCode value
     * @return string|null
     */
    public function getEurotaxCode()
    {
        return $this->eurotaxCode;
    }
    /**
     * Set eurotaxCode value
     * @param string $eurotaxCode
     * @return \StructType\MotorInsurable
     */
    public function setEurotaxCode($eurotaxCode = null)
    {
        // validation for constraint: string
        if (!is_null($eurotaxCode) && !is_string($eurotaxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eurotaxCode)), __LINE__);
        }
        $this->eurotaxCode = $eurotaxCode;
        return $this;
    }
    /**
     * Get manufacturerYear value
     * @return int|null
     */
    public function getManufacturerYear()
    {
        return $this->manufacturerYear;
    }
    /**
     * Set manufacturerYear value
     * @param int $manufacturerYear
     * @return \StructType\MotorInsurable
     */
    public function setManufacturerYear($manufacturerYear = null)
    {
        // validation for constraint: int
        if (!is_null($manufacturerYear) && !is_numeric($manufacturerYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($manufacturerYear)), __LINE__);
        }
        $this->manufacturerYear = $manufacturerYear;
        return $this;
    }
    /**
     * Get marketValue value
     * @return float|null
     */
    public function getMarketValue()
    {
        return $this->marketValue;
    }
    /**
     * Set marketValue value
     * @param float $marketValue
     * @return \StructType\MotorInsurable
     */
    public function setMarketValue($marketValue = null)
    {
        $this->marketValue = $marketValue;
        return $this;
    }
    /**
     * Get motorMakeCode value
     * @return string|null
     */
    public function getMotorMakeCode()
    {
        return $this->motorMakeCode;
    }
    /**
     * Set motorMakeCode value
     * @param string $motorMakeCode
     * @return \StructType\MotorInsurable
     */
    public function setMotorMakeCode($motorMakeCode = null)
    {
        // validation for constraint: string
        if (!is_null($motorMakeCode) && !is_string($motorMakeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($motorMakeCode)), __LINE__);
        }
        $this->motorMakeCode = $motorMakeCode;
        return $this;
    }
    /**
     * Get motorUseCode value
     * @return string|null
     */
    public function getMotorUseCode()
    {
        return $this->motorUseCode;
    }
    /**
     * Set motorUseCode value
     * @param string $motorUseCode
     * @return \StructType\MotorInsurable
     */
    public function setMotorUseCode($motorUseCode = null)
    {
        // validation for constraint: string
        if (!is_null($motorUseCode) && !is_string($motorUseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($motorUseCode)), __LINE__);
        }
        $this->motorUseCode = $motorUseCode;
        return $this;
    }
    /**
     * Get noOfClaims value
     * @return int|null
     */
    public function getNoOfClaims()
    {
        return $this->noOfClaims;
    }
    /**
     * Set noOfClaims value
     * @param int $noOfClaims
     * @return \StructType\MotorInsurable
     */
    public function setNoOfClaims($noOfClaims = null)
    {
        // validation for constraint: int
        if (!is_null($noOfClaims) && !is_numeric($noOfClaims)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($noOfClaims)), __LINE__);
        }
        $this->noOfClaims = $noOfClaims;
        return $this;
    }
    /**
     * Get plateNo value
     * @return string|null
     */
    public function getPlateNo()
    {
        return $this->plateNo;
    }
    /**
     * Set plateNo value
     * @param string $plateNo
     * @return \StructType\MotorInsurable
     */
    public function setPlateNo($plateNo = null)
    {
        // validation for constraint: string
        if (!is_null($plateNo) && !is_string($plateNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($plateNo)), __LINE__);
        }
        $this->plateNo = $plateNo;
        return $this;
    }
    /**
     * Get protectionMeasures value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getProtectionMeasures()
    {
        return isset($this->protectionMeasures) ? $this->protectionMeasures : null;
    }
    /**
     * Set protectionMeasures value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $protectionMeasures
     * @return \StructType\MotorInsurable
     */
    public function setProtectionMeasures(array $protectionMeasures = array())
    {
        foreach ($protectionMeasures as $motorInsurableProtectionMeasuresItem) {
            // validation for constraint: itemType
            if (!is_string($motorInsurableProtectionMeasuresItem)) {
                throw new \InvalidArgumentException(sprintf('The protectionMeasures property can only contain items of string, "%s" given', is_object($motorInsurableProtectionMeasuresItem) ? get_class($motorInsurableProtectionMeasuresItem) : gettype($motorInsurableProtectionMeasuresItem)), __LINE__);
            }
        }
        if (is_null($protectionMeasures) || (is_array($protectionMeasures) && empty($protectionMeasures))) {
            unset($this->protectionMeasures);
        } else {
            $this->protectionMeasures = $protectionMeasures;
        }
        return $this;
    }
    /**
     * Add item to protectionMeasures value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\MotorInsurable
     */
    public function addToProtectionMeasures($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The protectionMeasures property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->protectionMeasures[] = $item;
        return $this;
    }
    /**
     * Get provinceCode value
     * @return string|null
     */
    public function getProvinceCode()
    {
        return $this->provinceCode;
    }
    /**
     * Set provinceCode value
     * @param string $provinceCode
     * @return \StructType\MotorInsurable
     */
    public function setProvinceCode($provinceCode = null)
    {
        // validation for constraint: string
        if (!is_null($provinceCode) && !is_string($provinceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provinceCode)), __LINE__);
        }
        $this->provinceCode = $provinceCode;
        return $this;
    }
    /**
     * Get purchasedDate value
     * @return string|null
     */
    public function getPurchasedDate()
    {
        return $this->purchasedDate;
    }
    /**
     * Set purchasedDate value
     * @param string $purchasedDate
     * @return \StructType\MotorInsurable
     */
    public function setPurchasedDate($purchasedDate = null)
    {
        // validation for constraint: string
        if (!is_null($purchasedDate) && !is_string($purchasedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($purchasedDate)), __LINE__);
        }
        $this->purchasedDate = $purchasedDate;
        return $this;
    }
    /**
     * Get taxHp value
     * @return int|null
     */
    public function getTaxHp()
    {
        return $this->taxHp;
    }
    /**
     * Set taxHp value
     * @param int $taxHp
     * @return \StructType\MotorInsurable
     */
    public function setTaxHp($taxHp = null)
    {
        // validation for constraint: int
        if (!is_null($taxHp) && !is_numeric($taxHp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($taxHp)), __LINE__);
        }
        $this->taxHp = $taxHp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MotorInsurable
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
