<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Message StructType
 * @subpackage Structs
 */
class Message extends AbstractStructBase
{
    /**
     * The severity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $severity;
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $code;
    /**
     * The target
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $target;
    /**
     * The body
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $body;
    /**
     * Constructor method for Message
     * @uses Message::setSeverity()
     * @uses Message::setCode()
     * @uses Message::setTarget()
     * @uses Message::setBody()
     * @param string $severity
     * @param int $code
     * @param string $target
     * @param string $body
     */
    public function __construct($severity = null, $code = null, $target = null, $body = null)
    {
        $this
            ->setSeverity($severity)
            ->setCode($code)
            ->setTarget($target)
            ->setBody($body);
    }
    /**
     * Get severity value
     * @return string|null
     */
    public function getSeverity()
    {
        return $this->severity;
    }
    /**
     * Set severity value
     * @param string $severity
     * @return \StructType\Message
     */
    public function setSeverity($severity = null)
    {
        // validation for constraint: string
        if (!is_null($severity) && !is_string($severity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($severity)), __LINE__);
        }
        $this->severity = $severity;
        return $this;
    }
    /**
     * Get code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param int $code
     * @return \StructType\Message
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !is_numeric($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->target;
    }
    /**
     * Set target value
     * @param string $target
     * @return \StructType\Message
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->target = $target;
        return $this;
    }
    /**
     * Get body value
     * @return string|null
     */
    public function getBody()
    {
        return $this->body;
    }
    /**
     * Set body value
     * @param string $body
     * @return \StructType\Message
     */
    public function setBody($body = null)
    {
        // validation for constraint: string
        if (!is_null($body) && !is_string($body)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($body)), __LINE__);
        }
        $this->body = $body;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Message
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
