<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoverParamInfo StructType
 * @subpackage Structs
 */
class CoverParamInfo extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Value
     */
    public $value;
    /**
     * The option
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ParamInfo[]
     */
    public $option;
    /**
     * Constructor method for CoverParamInfo
     * @uses CoverParamInfo::setType()
     * @uses CoverParamInfo::setDescription()
     * @uses CoverParamInfo::setValue()
     * @uses CoverParamInfo::setOption()
     * @param string $type
     * @param string $description
     * @param \StructType\Value $value
     * @param \StructType\ParamInfo[] $option
     */
    public function __construct($type = null, $description = null, \StructType\Value $value = null, array $option = array())
    {
        $this
            ->setType($type)
            ->setDescription($description)
            ->setValue($value)
            ->setOption($option);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\CoverParamInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\CoverParamInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get value value
     * @return \StructType\Value|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param \StructType\Value $value
     * @return \StructType\CoverParamInfo
     */
    public function setValue(\StructType\Value $value = null)
    {
        $this->value = $value;
        return $this;
    }
    /**
     * Get option value
     * @return \StructType\ParamInfo[]|null
     */
    public function getOption()
    {
        return $this->option;
    }
    /**
     * Set option value
     * @throws \InvalidArgumentException
     * @param \StructType\ParamInfo[] $option
     * @return \StructType\CoverParamInfo
     */
    public function setOption(array $option = array())
    {
        foreach ($option as $coverParamInfoOptionItem) {
            // validation for constraint: itemType
            if (!$coverParamInfoOptionItem instanceof \StructType\ParamInfo) {
                throw new \InvalidArgumentException(sprintf('The option property can only contain items of \StructType\ParamInfo, "%s" given', is_object($coverParamInfoOptionItem) ? get_class($coverParamInfoOptionItem) : gettype($coverParamInfoOptionItem)), __LINE__);
            }
        }
        $this->option = $option;
        return $this;
    }
    /**
     * Add item to option value
     * @throws \InvalidArgumentException
     * @param \StructType\ParamInfo $item
     * @return \StructType\CoverParamInfo
     */
    public function addToOption(\StructType\ParamInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParamInfo) {
            throw new \InvalidArgumentException(sprintf('The option property can only contain items of \StructType\ParamInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->option[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CoverParamInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
