<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoverInfo StructType
 * @subpackage Structs
 */
class CoverInfo extends AbstractStructBase
{
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The mandatory
     * @var bool
     */
    public $mandatory;
    /**
     * The sumInsured
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FieldInfo
     */
    public $sumInsured;
    /**
     * The premium
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FieldInfo
     */
    public $premium;
    /**
     * The param
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CoverParamInfo[]
     */
    public $param;
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * Constructor method for CoverInfo
     * @uses CoverInfo::setDescription()
     * @uses CoverInfo::setMandatory()
     * @uses CoverInfo::setSumInsured()
     * @uses CoverInfo::setPremium()
     * @uses CoverInfo::setParam()
     * @uses CoverInfo::setCode()
     * @param string $description
     * @param bool $mandatory
     * @param \StructType\FieldInfo $sumInsured
     * @param \StructType\FieldInfo $premium
     * @param \StructType\CoverParamInfo[] $param
     * @param string $code
     */
    public function __construct($description = null, $mandatory = null, \StructType\FieldInfo $sumInsured = null, \StructType\FieldInfo $premium = null, array $param = array(), $code = null)
    {
        $this
            ->setDescription($description)
            ->setMandatory($mandatory)
            ->setSumInsured($sumInsured)
            ->setPremium($premium)
            ->setParam($param)
            ->setCode($code);
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\CoverInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get mandatory value
     * @return bool|null
     */
    public function getMandatory()
    {
        return $this->mandatory;
    }
    /**
     * Set mandatory value
     * @param bool $mandatory
     * @return \StructType\CoverInfo
     */
    public function setMandatory($mandatory = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatory) && !is_bool($mandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mandatory)), __LINE__);
        }
        $this->mandatory = $mandatory;
        return $this;
    }
    /**
     * Get sumInsured value
     * @return \StructType\FieldInfo|null
     */
    public function getSumInsured()
    {
        return $this->sumInsured;
    }
    /**
     * Set sumInsured value
     * @param \StructType\FieldInfo $sumInsured
     * @return \StructType\CoverInfo
     */
    public function setSumInsured(\StructType\FieldInfo $sumInsured = null)
    {
        $this->sumInsured = $sumInsured;
        return $this;
    }
    /**
     * Get premium value
     * @return \StructType\FieldInfo|null
     */
    public function getPremium()
    {
        return $this->premium;
    }
    /**
     * Set premium value
     * @param \StructType\FieldInfo $premium
     * @return \StructType\CoverInfo
     */
    public function setPremium(\StructType\FieldInfo $premium = null)
    {
        $this->premium = $premium;
        return $this;
    }
    /**
     * Get param value
     * @return \StructType\CoverParamInfo[]|null
     */
    public function getParam()
    {
        return $this->param;
    }
    /**
     * Set param value
     * @throws \InvalidArgumentException
     * @param \StructType\CoverParamInfo[] $param
     * @return \StructType\CoverInfo
     */
    public function setParam(array $param = array())
    {
        foreach ($param as $coverInfoParamItem) {
            // validation for constraint: itemType
            if (!$coverInfoParamItem instanceof \StructType\CoverParamInfo) {
                throw new \InvalidArgumentException(sprintf('The param property can only contain items of \StructType\CoverParamInfo, "%s" given', is_object($coverInfoParamItem) ? get_class($coverInfoParamItem) : gettype($coverInfoParamItem)), __LINE__);
            }
        }
        $this->param = $param;
        return $this;
    }
    /**
     * Add item to param value
     * @throws \InvalidArgumentException
     * @param \StructType\CoverParamInfo $item
     * @return \StructType\CoverInfo
     */
    public function addToParam(\StructType\CoverParamInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CoverParamInfo) {
            throw new \InvalidArgumentException(sprintf('The param property can only contain items of \StructType\CoverParamInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->param[] = $item;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\CoverInfo
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CoverInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
