<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Pendencies ServiceType
 * @subpackage Services
 */
class Pendencies extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named listOpenPendencies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListOpenPendencies $parameters
     * @return \StructType\ListOpenPendenciesResponse|bool
     */
    public function listOpenPendencies(\StructType\ListOpenPendencies $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->listOpenPendencies($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ListOpenPendenciesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
