<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Info ServiceType
 * @subpackage Services
 */
class Info extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getPackageInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPackageInfo $parameters
     * @return \StructType\GetPackageInfoResponse|bool
     */
    public function getPackageInfo(\StructType\GetPackageInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getPackageInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listPackagesInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListPackagesInfo $parameters
     * @return \StructType\ListPackagesInfoResponse|bool
     */
    public function listPackagesInfo(\StructType\ListPackagesInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->listPackagesInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetPackageInfoResponse|\StructType\ListPackagesInfoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
