<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Document ServiceType
 * @subpackage Services
 */
class Document extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getQuotationDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetQuotationDocument $parameters
     * @return \StructType\GetQuotationDocumentResponse|bool
     */
    public function getQuotationDocument(\StructType\GetQuotationDocument $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getQuotationDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetQuotationDocumentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
