<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://195.97.77.20/gbox-ws/soap/v2/quotation?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://195.97.77.20/gbox-ws/soap/v2/quotation?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Info ServiceType
 */
$info = new \ServiceType\Info($options);
/**
 * Sample call for getPackageInfo operation/method
 */
if ($info->getPackageInfo(new \StructType\GetPackageInfo()) !== false) {
    print_r($info->getResult());
} else {
    print_r($info->getLastError());
}
/**
 * Sample call for listPackagesInfo operation/method
 */
if ($info->listPackagesInfo(new \StructType\ListPackagesInfo()) !== false) {
    print_r($info->getResult());
} else {
    print_r($info->getLastError());
}
/**
 * Samples for Status ServiceType
 */
$status = new \ServiceType\Status($options);
/**
 * Sample call for getQuotationStatus operation/method
 */
if ($status->getQuotationStatus(new \StructType\GetQuotationStatus()) !== false) {
    print_r($status->getResult());
} else {
    print_r($status->getLastError());
}
/**
 * Samples for Issue ServiceType
 */
$issue = new \ServiceType\Issue($options);
/**
 * Sample call for issue operation/method
 */
if ($issue->issue(new \StructType\Issue()) !== false) {
    print_r($issue->getResult());
} else {
    print_r($issue->getLastError());
}
/**
 * Samples for Tariffy ServiceType
 */
$tariffy = new \ServiceType\Tariffy($options);
/**
 * Sample call for tariffy operation/method
 */
if ($tariffy->tariffy(new \StructType\Tariffy()) !== false) {
    print_r($tariffy->getResult());
} else {
    print_r($tariffy->getLastError());
}
/**
 * Samples for Pendencies ServiceType
 */
$pendencies = new \ServiceType\Pendencies($options);
/**
 * Sample call for listOpenPendencies operation/method
 */
if ($pendencies->listOpenPendencies(new \StructType\ListOpenPendencies()) !== false) {
    print_r($pendencies->getResult());
} else {
    print_r($pendencies->getLastError());
}
/**
 * Samples for Pendency ServiceType
 */
$pendency = new \ServiceType\Pendency($options);
/**
 * Sample call for uploadPendency operation/method
 */
if ($pendency->uploadPendency(new \StructType\UploadPendency()) !== false) {
    print_r($pendency->getResult());
} else {
    print_r($pendency->getLastError());
}
/**
 * Samples for Document ServiceType
 */
$document = new \ServiceType\Document($options);
/**
 * Sample call for getQuotationDocument operation/method
 */
if ($document->getQuotationDocument(new \StructType\GetQuotationDocument()) !== false) {
    print_r($document->getResult());
} else {
    print_r($document->getLastError());
}
