<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for uploadPendency StructType
 * Meta informations extracted from the WSDL
 * - type: tns:uploadPendency
 * @subpackage Structs
 */
class UploadPendency extends AbstractStructBase
{
    /**
     * The pendencyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pendencyCode;
    /**
     * The quotationCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $quotationCode;
    /**
     * The title
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The content
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $content;
    /**
     * Constructor method for uploadPendency
     * @uses UploadPendency::setPendencyCode()
     * @uses UploadPendency::setQuotationCode()
     * @uses UploadPendency::setTitle()
     * @uses UploadPendency::setContent()
     * @param string $pendencyCode
     * @param string $quotationCode
     * @param string $title
     * @param string $content
     */
    public function __construct($pendencyCode = null, $quotationCode = null, $title = null, $content = null)
    {
        $this
            ->setPendencyCode($pendencyCode)
            ->setQuotationCode($quotationCode)
            ->setTitle($title)
            ->setContent($content);
    }
    /**
     * Get pendencyCode value
     * @return string|null
     */
    public function getPendencyCode()
    {
        return $this->pendencyCode;
    }
    /**
     * Set pendencyCode value
     * @param string $pendencyCode
     * @return \StructType\UploadPendency
     */
    public function setPendencyCode($pendencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($pendencyCode) && !is_string($pendencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pendencyCode)), __LINE__);
        }
        $this->pendencyCode = $pendencyCode;
        return $this;
    }
    /**
     * Get quotationCode value
     * @return string|null
     */
    public function getQuotationCode()
    {
        return $this->quotationCode;
    }
    /**
     * Set quotationCode value
     * @param string $quotationCode
     * @return \StructType\UploadPendency
     */
    public function setQuotationCode($quotationCode = null)
    {
        // validation for constraint: string
        if (!is_null($quotationCode) && !is_string($quotationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quotationCode)), __LINE__);
        }
        $this->quotationCode = $quotationCode;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\UploadPendency
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return \StructType\UploadPendency
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UploadPendency
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
