<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TotalPremium StructType
 * @subpackage Structs
 */
class TotalPremium extends AbstractStructBase
{
    /**
     * The duration
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentFrequency
     */
    public $duration;
    /**
     * The grossAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $grossAmount;
    /**
     * The netAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $netAmount;
    /**
     * Constructor method for TotalPremium
     * @uses TotalPremium::setDuration()
     * @uses TotalPremium::setGrossAmount()
     * @uses TotalPremium::setNetAmount()
     * @param \StructType\PaymentFrequency $duration
     * @param float $grossAmount
     * @param float $netAmount
     */
    public function __construct(\StructType\PaymentFrequency $duration = null, $grossAmount = null, $netAmount = null)
    {
        $this
            ->setDuration($duration)
            ->setGrossAmount($grossAmount)
            ->setNetAmount($netAmount);
    }
    /**
     * Get duration value
     * @return \StructType\PaymentFrequency|null
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @param \StructType\PaymentFrequency $duration
     * @return \StructType\TotalPremium
     */
    public function setDuration(\StructType\PaymentFrequency $duration = null)
    {
        $this->duration = $duration;
        return $this;
    }
    /**
     * Get grossAmount value
     * @return float|null
     */
    public function getGrossAmount()
    {
        return $this->grossAmount;
    }
    /**
     * Set grossAmount value
     * @param float $grossAmount
     * @return \StructType\TotalPremium
     */
    public function setGrossAmount($grossAmount = null)
    {
        $this->grossAmount = $grossAmount;
        return $this;
    }
    /**
     * Get netAmount value
     * @return float|null
     */
    public function getNetAmount()
    {
        return $this->netAmount;
    }
    /**
     * Set netAmount value
     * @param float $netAmount
     * @return \StructType\TotalPremium
     */
    public function setNetAmount($netAmount = null)
    {
        $this->netAmount = $netAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TotalPremium
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
