<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tariffy StructType
 * Meta informations extracted from the WSDL
 * - type: tns:tariffy
 * @subpackage Structs
 */
class Tariffy extends AbstractStructBase
{
    /**
     * The distChannel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $distChannel;
    /**
     * The duration
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $duration;
    /**
     * The insuranceStartDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $insuranceStartDate;
    /**
     * The policyHolder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Person
     */
    public $policyHolder;
    /**
     * The insurable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Insurable
     */
    public $insurable;
    /**
     * The pack
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Pack
     */
    public $pack;
    /**
     * Constructor method for tariffy
     * @uses Tariffy::setDistChannel()
     * @uses Tariffy::setDuration()
     * @uses Tariffy::setInsuranceStartDate()
     * @uses Tariffy::setPolicyHolder()
     * @uses Tariffy::setInsurable()
     * @uses Tariffy::setPack()
     * @param string $distChannel
     * @param int $duration
     * @param string $insuranceStartDate
     * @param \StructType\Person $policyHolder
     * @param \StructType\Insurable $insurable
     * @param \StructType\Pack $pack
     */
    public function __construct($distChannel = null, $duration = null, $insuranceStartDate = null, \StructType\Person $policyHolder = null, \StructType\Insurable $insurable = null, \StructType\Pack $pack = null)
    {
        $this
            ->setDistChannel($distChannel)
            ->setDuration($duration)
            ->setInsuranceStartDate($insuranceStartDate)
            ->setPolicyHolder($policyHolder)
            ->setInsurable($insurable)
            ->setPack($pack);
    }
    /**
     * Get distChannel value
     * @return string|null
     */
    public function getDistChannel()
    {
        return $this->distChannel;
    }
    /**
     * Set distChannel value
     * @param string $distChannel
     * @return \StructType\Tariffy
     */
    public function setDistChannel($distChannel = null)
    {
        // validation for constraint: string
        if (!is_null($distChannel) && !is_string($distChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distChannel)), __LINE__);
        }
        $this->distChannel = $distChannel;
        return $this;
    }
    /**
     * Get duration value
     * @return int|null
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @param int $duration
     * @return \StructType\Tariffy
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !is_numeric($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($duration)), __LINE__);
        }
        $this->duration = $duration;
        return $this;
    }
    /**
     * Get insuranceStartDate value
     * @return string|null
     */
    public function getInsuranceStartDate()
    {
        return $this->insuranceStartDate;
    }
    /**
     * Set insuranceStartDate value
     * @param string $insuranceStartDate
     * @return \StructType\Tariffy
     */
    public function setInsuranceStartDate($insuranceStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($insuranceStartDate) && !is_string($insuranceStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($insuranceStartDate)), __LINE__);
        }
        $this->insuranceStartDate = $insuranceStartDate;
        return $this;
    }
    /**
     * Get policyHolder value
     * @return \StructType\Person|null
     */
    public function getPolicyHolder()
    {
        return $this->policyHolder;
    }
    /**
     * Set policyHolder value
     * @param \StructType\Person $policyHolder
     * @return \StructType\Tariffy
     */
    public function setPolicyHolder(\StructType\Person $policyHolder = null)
    {
        $this->policyHolder = $policyHolder;
        return $this;
    }
    /**
     * Get insurable value
     * @return \StructType\Insurable|null
     */
    public function getInsurable()
    {
        return $this->insurable;
    }
    /**
     * Set insurable value
     * @param \StructType\Insurable $insurable
     * @return \StructType\Tariffy
     */
    public function setInsurable(\StructType\Insurable $insurable = null)
    {
        $this->insurable = $insurable;
        return $this;
    }
    /**
     * Get pack value
     * @return \StructType\Pack|null
     */
    public function getPack()
    {
        return $this->pack;
    }
    /**
     * Set pack value
     * @param \StructType\Pack $pack
     * @return \StructType\Tariffy
     */
    public function setPack(\StructType\Pack $pack = null)
    {
        $this->pack = $pack;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Tariffy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
