<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tariffication StructType
 * @subpackage Structs
 */
class Tariffication extends AbstractStructBase
{
    /**
     * The requestCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $requestCode;
    /**
     * The totalPremiumNet
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalPremiumNet;
    /**
     * The totalPremiumGross
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalPremiumGross;
    /**
     * The pack
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Pack
     */
    public $pack;
    /**
     * The report
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Report
     */
    public $report;
    /**
     * Constructor method for Tariffication
     * @uses Tariffication::setRequestCode()
     * @uses Tariffication::setTotalPremiumNet()
     * @uses Tariffication::setTotalPremiumGross()
     * @uses Tariffication::setPack()
     * @uses Tariffication::setReport()
     * @param string $requestCode
     * @param float $totalPremiumNet
     * @param float $totalPremiumGross
     * @param \StructType\Pack $pack
     * @param \StructType\Report $report
     */
    public function __construct($requestCode = null, $totalPremiumNet = null, $totalPremiumGross = null, \StructType\Pack $pack = null, \StructType\Report $report = null)
    {
        $this
            ->setRequestCode($requestCode)
            ->setTotalPremiumNet($totalPremiumNet)
            ->setTotalPremiumGross($totalPremiumGross)
            ->setPack($pack)
            ->setReport($report);
    }
    /**
     * Get requestCode value
     * @return string|null
     */
    public function getRequestCode()
    {
        return $this->requestCode;
    }
    /**
     * Set requestCode value
     * @param string $requestCode
     * @return \StructType\Tariffication
     */
    public function setRequestCode($requestCode = null)
    {
        // validation for constraint: string
        if (!is_null($requestCode) && !is_string($requestCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestCode)), __LINE__);
        }
        $this->requestCode = $requestCode;
        return $this;
    }
    /**
     * Get totalPremiumNet value
     * @return float|null
     */
    public function getTotalPremiumNet()
    {
        return $this->totalPremiumNet;
    }
    /**
     * Set totalPremiumNet value
     * @param float $totalPremiumNet
     * @return \StructType\Tariffication
     */
    public function setTotalPremiumNet($totalPremiumNet = null)
    {
        $this->totalPremiumNet = $totalPremiumNet;
        return $this;
    }
    /**
     * Get totalPremiumGross value
     * @return float|null
     */
    public function getTotalPremiumGross()
    {
        return $this->totalPremiumGross;
    }
    /**
     * Set totalPremiumGross value
     * @param float $totalPremiumGross
     * @return \StructType\Tariffication
     */
    public function setTotalPremiumGross($totalPremiumGross = null)
    {
        $this->totalPremiumGross = $totalPremiumGross;
        return $this;
    }
    /**
     * Get pack value
     * @return \StructType\Pack|null
     */
    public function getPack()
    {
        return $this->pack;
    }
    /**
     * Set pack value
     * @param \StructType\Pack $pack
     * @return \StructType\Tariffication
     */
    public function setPack(\StructType\Pack $pack = null)
    {
        $this->pack = $pack;
        return $this;
    }
    /**
     * Get report value
     * @return \StructType\Report|null
     */
    public function getReport()
    {
        return $this->report;
    }
    /**
     * Set report value
     * @param \StructType\Report $report
     * @return \StructType\Tariffication
     */
    public function setReport(\StructType\Report $report = null)
    {
        $this->report = $report;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Tariffication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
