<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackInfo StructType
 * @subpackage Structs
 */
class PackInfo extends AbstractStructBase
{
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The cover
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CoverInfo[]
     */
    public $cover;
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * Constructor method for PackInfo
     * @uses PackInfo::setDescription()
     * @uses PackInfo::setCover()
     * @uses PackInfo::setCode()
     * @param string $description
     * @param \StructType\CoverInfo[] $cover
     * @param string $code
     */
    public function __construct($description = null, array $cover = array(), $code = null)
    {
        $this
            ->setDescription($description)
            ->setCover($cover)
            ->setCode($code);
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\PackInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get cover value
     * @return \StructType\CoverInfo[]|null
     */
    public function getCover()
    {
        return $this->cover;
    }
    /**
     * Set cover value
     * @throws \InvalidArgumentException
     * @param \StructType\CoverInfo[] $cover
     * @return \StructType\PackInfo
     */
    public function setCover(array $cover = array())
    {
        foreach ($cover as $packInfoCoverItem) {
            // validation for constraint: itemType
            if (!$packInfoCoverItem instanceof \StructType\CoverInfo) {
                throw new \InvalidArgumentException(sprintf('The cover property can only contain items of \StructType\CoverInfo, "%s" given', is_object($packInfoCoverItem) ? get_class($packInfoCoverItem) : gettype($packInfoCoverItem)), __LINE__);
            }
        }
        $this->cover = $cover;
        return $this;
    }
    /**
     * Add item to cover value
     * @throws \InvalidArgumentException
     * @param \StructType\CoverInfo $item
     * @return \StructType\PackInfo
     */
    public function addToCover(\StructType\CoverInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CoverInfo) {
            throw new \InvalidArgumentException(sprintf('The cover property can only contain items of \StructType\CoverInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->cover[] = $item;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\PackInfo
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PackInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
