<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HomeQuotation StructType
 * @subpackage Structs
 */
class HomeQuotation extends Quotation
{
    /**
     * The floorType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $floorType;
    /**
     * Constructor method for HomeQuotation
     * @uses HomeQuotation::setFloorType()
     * @param string $floorType
     */
    public function __construct($floorType = null)
    {
        $this
            ->setFloorType($floorType);
    }
    /**
     * Get floorType value
     * @return string|null
     */
    public function getFloorType()
    {
        return $this->floorType;
    }
    /**
     * Set floorType value
     * @param string $floorType
     * @return \StructType\HomeQuotation
     */
    public function setFloorType($floorType = null)
    {
        // validation for constraint: string
        if (!is_null($floorType) && !is_string($floorType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($floorType)), __LINE__);
        }
        $this->floorType = $floorType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HomeQuotation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
