<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cover StructType
 * @subpackage Structs
 */
class Cover extends AbstractStructBase
{
    /**
     * The param
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CoverParam[]
     */
    public $param;
    /**
     * The premium
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Value
     */
    public $premium;
    /**
     * The sumInsured
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Value
     */
    public $sumInsured;
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * Constructor method for Cover
     * @uses Cover::setParam()
     * @uses Cover::setPremium()
     * @uses Cover::setSumInsured()
     * @uses Cover::setCode()
     * @param \StructType\CoverParam[] $param
     * @param \StructType\Value $premium
     * @param \StructType\Value $sumInsured
     * @param string $code
     */
    public function __construct(array $param = array(), \StructType\Value $premium = null, \StructType\Value $sumInsured = null, $code = null)
    {
        $this
            ->setParam($param)
            ->setPremium($premium)
            ->setSumInsured($sumInsured)
            ->setCode($code);
    }
    /**
     * Get param value
     * @return \StructType\CoverParam[]|null
     */
    public function getParam()
    {
        return $this->param;
    }
    /**
     * Set param value
     * @throws \InvalidArgumentException
     * @param \StructType\CoverParam[] $param
     * @return \StructType\Cover
     */
    public function setParam(array $param = array())
    {
        foreach ($param as $coverParamItem) {
            // validation for constraint: itemType
            if (!$coverParamItem instanceof \StructType\CoverParam) {
                throw new \InvalidArgumentException(sprintf('The param property can only contain items of \StructType\CoverParam, "%s" given', is_object($coverParamItem) ? get_class($coverParamItem) : gettype($coverParamItem)), __LINE__);
            }
        }
        $this->param = $param;
        return $this;
    }
    /**
     * Add item to param value
     * @throws \InvalidArgumentException
     * @param \StructType\CoverParam $item
     * @return \StructType\Cover
     */
    public function addToParam(\StructType\CoverParam $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CoverParam) {
            throw new \InvalidArgumentException(sprintf('The param property can only contain items of \StructType\CoverParam, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->param[] = $item;
        return $this;
    }
    /**
     * Get premium value
     * @return \StructType\Value|null
     */
    public function getPremium()
    {
        return $this->premium;
    }
    /**
     * Set premium value
     * @param \StructType\Value $premium
     * @return \StructType\Cover
     */
    public function setPremium(\StructType\Value $premium = null)
    {
        $this->premium = $premium;
        return $this;
    }
    /**
     * Get sumInsured value
     * @return \StructType\Value|null
     */
    public function getSumInsured()
    {
        return $this->sumInsured;
    }
    /**
     * Set sumInsured value
     * @param \StructType\Value $sumInsured
     * @return \StructType\Cover
     */
    public function setSumInsured(\StructType\Value $sumInsured = null)
    {
        $this->sumInsured = $sumInsured;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\Cover
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Cover
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
