<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Status ServiceType
 * @subpackage Services
 */
class Status extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getQuotationStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetQuotationStatus $parameters
     * @return \StructType\GetQuotationStatusResponse|bool
     */
    public function getQuotationStatus(\StructType\GetQuotationStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getQuotationStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetQuotationStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
