<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateProductPriceByIdRequest StructType
 * @subpackage Structs
 */
class UpdateProductPriceByIdRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The productId
     * @var int
     */
    public $productId;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The currencyType
     * @var int
     */
    public $currencyType;
    /**
     * The stockItems
     * @var \StructType\ProductSkuBasicRequestItemList
     */
    public $stockItems;
    /**
     * Constructor method for UpdateProductPriceByIdRequest
     * @uses UpdateProductPriceByIdRequest::setAuth()
     * @uses UpdateProductPriceByIdRequest::setProductId()
     * @uses UpdateProductPriceByIdRequest::setPrice()
     * @uses UpdateProductPriceByIdRequest::setCurrencyType()
     * @uses UpdateProductPriceByIdRequest::setStockItems()
     * @param \StructType\Authentication $auth
     * @param int $productId
     * @param float $price
     * @param int $currencyType
     * @param \StructType\ProductSkuBasicRequestItemList $stockItems
     */
    public function __construct(\StructType\Authentication $auth = null, $productId = null, $price = null, $currencyType = null, \StructType\ProductSkuBasicRequestItemList $stockItems = null)
    {
        $this
            ->setAuth($auth)
            ->setProductId($productId)
            ->setPrice($price)
            ->setCurrencyType($currencyType)
            ->setStockItems($stockItems);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\UpdateProductPriceByIdRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\UpdateProductPriceByIdRequest
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !is_numeric($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\UpdateProductPriceByIdRequest
     */
    public function setPrice($price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get currencyType value
     * @return int|null
     */
    public function getCurrencyType()
    {
        return $this->currencyType;
    }
    /**
     * Set currencyType value
     * @param int $currencyType
     * @return \StructType\UpdateProductPriceByIdRequest
     */
    public function setCurrencyType($currencyType = null)
    {
        // validation for constraint: int
        if (!is_null($currencyType) && !is_numeric($currencyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currencyType)), __LINE__);
        }
        $this->currencyType = $currencyType;
        return $this;
    }
    /**
     * Get stockItems value
     * @return \StructType\ProductSkuBasicRequestItemList|null
     */
    public function getStockItems()
    {
        return $this->stockItems;
    }
    /**
     * Set stockItems value
     * @param \StructType\ProductSkuBasicRequestItemList $stockItems
     * @return \StructType\UpdateProductPriceByIdRequest
     */
    public function setStockItems(\StructType\ProductSkuBasicRequestItemList $stockItems = null)
    {
        $this->stockItems = $stockItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateProductPriceByIdRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
