<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateProductBasicRequest StructType
 * @subpackage Structs
 */
class UpdateProductBasicRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The productId
     * @var int
     */
    public $productId;
    /**
     * The productSellerCode
     * @var string
     */
    public $productSellerCode;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The productDiscount
     * @var \StructType\SellerProductDiscount
     */
    public $productDiscount;
    /**
     * The stockItems
     * @var \StructType\ProductUpdateSkuBasicRequestItemList
     */
    public $stockItems;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The images
     * @var \StructType\ProductImageList
     */
    public $images;
    /**
     * Constructor method for UpdateProductBasicRequest
     * @uses UpdateProductBasicRequest::setAuth()
     * @uses UpdateProductBasicRequest::setProductId()
     * @uses UpdateProductBasicRequest::setProductSellerCode()
     * @uses UpdateProductBasicRequest::setPrice()
     * @uses UpdateProductBasicRequest::setProductDiscount()
     * @uses UpdateProductBasicRequest::setStockItems()
     * @uses UpdateProductBasicRequest::setDescription()
     * @uses UpdateProductBasicRequest::setImages()
     * @param \StructType\Authentication $auth
     * @param int $productId
     * @param string $productSellerCode
     * @param float $price
     * @param \StructType\SellerProductDiscount $productDiscount
     * @param \StructType\ProductUpdateSkuBasicRequestItemList $stockItems
     * @param string $description
     * @param \StructType\ProductImageList $images
     */
    public function __construct(\StructType\Authentication $auth = null, $productId = null, $productSellerCode = null, $price = null, \StructType\SellerProductDiscount $productDiscount = null, \StructType\ProductUpdateSkuBasicRequestItemList $stockItems = null, $description = null, \StructType\ProductImageList $images = null)
    {
        $this
            ->setAuth($auth)
            ->setProductId($productId)
            ->setProductSellerCode($productSellerCode)
            ->setPrice($price)
            ->setProductDiscount($productDiscount)
            ->setStockItems($stockItems)
            ->setDescription($description)
            ->setImages($images);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\UpdateProductBasicRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\UpdateProductBasicRequest
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !is_numeric($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get productSellerCode value
     * @return string|null
     */
    public function getProductSellerCode()
    {
        return $this->productSellerCode;
    }
    /**
     * Set productSellerCode value
     * @param string $productSellerCode
     * @return \StructType\UpdateProductBasicRequest
     */
    public function setProductSellerCode($productSellerCode = null)
    {
        // validation for constraint: string
        if (!is_null($productSellerCode) && !is_string($productSellerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productSellerCode)), __LINE__);
        }
        $this->productSellerCode = $productSellerCode;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\UpdateProductBasicRequest
     */
    public function setPrice($price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get productDiscount value
     * @return \StructType\SellerProductDiscount|null
     */
    public function getProductDiscount()
    {
        return $this->productDiscount;
    }
    /**
     * Set productDiscount value
     * @param \StructType\SellerProductDiscount $productDiscount
     * @return \StructType\UpdateProductBasicRequest
     */
    public function setProductDiscount(\StructType\SellerProductDiscount $productDiscount = null)
    {
        $this->productDiscount = $productDiscount;
        return $this;
    }
    /**
     * Get stockItems value
     * @return \StructType\ProductUpdateSkuBasicRequestItemList|null
     */
    public function getStockItems()
    {
        return $this->stockItems;
    }
    /**
     * Set stockItems value
     * @param \StructType\ProductUpdateSkuBasicRequestItemList $stockItems
     * @return \StructType\UpdateProductBasicRequest
     */
    public function setStockItems(\StructType\ProductUpdateSkuBasicRequestItemList $stockItems = null)
    {
        $this->stockItems = $stockItems;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateProductBasicRequest
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get images value
     * @return \StructType\ProductImageList|null
     */
    public function getImages()
    {
        return $this->images;
    }
    /**
     * Set images value
     * @param \StructType\ProductImageList $images
     * @return \StructType\UpdateProductBasicRequest
     */
    public function setImages(\StructType\ProductImageList $images = null)
    {
        $this->images = $images;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateProductBasicRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
