<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockItemList StructType
 * @subpackage Structs
 */
class StockItemList extends AbstractStructBase
{
    /**
     * The stockItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\StockItem[]
     */
    public $stockItem;
    /**
     * Constructor method for StockItemList
     * @uses StockItemList::setStockItem()
     * @param \StructType\StockItem[] $stockItem
     */
    public function __construct(array $stockItem = array())
    {
        $this
            ->setStockItem($stockItem);
    }
    /**
     * Get stockItem value
     * @return \StructType\StockItem[]|null
     */
    public function getStockItem()
    {
        return $this->stockItem;
    }
    /**
     * Set stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItem[] $stockItem
     * @return \StructType\StockItemList
     */
    public function setStockItem(array $stockItem = array())
    {
        foreach ($stockItem as $stockItemListStockItemItem) {
            // validation for constraint: itemType
            if (!$stockItemListStockItemItem instanceof \StructType\StockItem) {
                throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\StockItem, "%s" given', is_object($stockItemListStockItemItem) ? get_class($stockItemListStockItemItem) : gettype($stockItemListStockItemItem)), __LINE__);
            }
        }
        $this->stockItem = $stockItem;
        return $this;
    }
    /**
     * Add item to stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItem $item
     * @return \StructType\StockItemList
     */
    public function addToStockItem(\StructType\StockItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockItem) {
            throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\StockItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockItemList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
