<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockItemForUpdateStockWithSellerStockCodeList StructType
 * @subpackage Structs
 */
class StockItemForUpdateStockWithSellerStockCodeList extends AbstractStructBase
{
    /**
     * The stockItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\StockItemForUpdateStockWithSellerStockCode[]
     */
    public $stockItem;
    /**
     * Constructor method for StockItemForUpdateStockWithSellerStockCodeList
     * @uses StockItemForUpdateStockWithSellerStockCodeList::setStockItem()
     * @param \StructType\StockItemForUpdateStockWithSellerStockCode[] $stockItem
     */
    public function __construct(array $stockItem = array())
    {
        $this
            ->setStockItem($stockItem);
    }
    /**
     * Get stockItem value
     * @return \StructType\StockItemForUpdateStockWithSellerStockCode[]|null
     */
    public function getStockItem()
    {
        return $this->stockItem;
    }
    /**
     * Set stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemForUpdateStockWithSellerStockCode[] $stockItem
     * @return \StructType\StockItemForUpdateStockWithSellerStockCodeList
     */
    public function setStockItem(array $stockItem = array())
    {
        foreach ($stockItem as $stockItemForUpdateStockWithSellerStockCodeListStockItemItem) {
            // validation for constraint: itemType
            if (!$stockItemForUpdateStockWithSellerStockCodeListStockItemItem instanceof \StructType\StockItemForUpdateStockWithSellerStockCode) {
                throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\StockItemForUpdateStockWithSellerStockCode, "%s" given', is_object($stockItemForUpdateStockWithSellerStockCodeListStockItemItem) ? get_class($stockItemForUpdateStockWithSellerStockCodeListStockItemItem) : gettype($stockItemForUpdateStockWithSellerStockCodeListStockItemItem)), __LINE__);
            }
        }
        $this->stockItem = $stockItem;
        return $this;
    }
    /**
     * Add item to stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemForUpdateStockWithSellerStockCode $item
     * @return \StructType\StockItemForUpdateStockWithSellerStockCodeList
     */
    public function addToStockItem(\StructType\StockItemForUpdateStockWithSellerStockCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockItemForUpdateStockWithSellerStockCode) {
            throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\StockItemForUpdateStockWithSellerStockCode, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockItemForUpdateStockWithSellerStockCodeList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
