<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockItemForUpdateStockWithAttributesList StructType
 * @subpackage Structs
 */
class StockItemForUpdateStockWithAttributesList extends AbstractStructBase
{
    /**
     * The stockItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\StockItemForUpdateStockWithAttributes[]
     */
    public $stockItem;
    /**
     * Constructor method for StockItemForUpdateStockWithAttributesList
     * @uses StockItemForUpdateStockWithAttributesList::setStockItem()
     * @param \StructType\StockItemForUpdateStockWithAttributes[] $stockItem
     */
    public function __construct(array $stockItem = array())
    {
        $this
            ->setStockItem($stockItem);
    }
    /**
     * Get stockItem value
     * @return \StructType\StockItemForUpdateStockWithAttributes[]|null
     */
    public function getStockItem()
    {
        return $this->stockItem;
    }
    /**
     * Set stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemForUpdateStockWithAttributes[] $stockItem
     * @return \StructType\StockItemForUpdateStockWithAttributesList
     */
    public function setStockItem(array $stockItem = array())
    {
        foreach ($stockItem as $stockItemForUpdateStockWithAttributesListStockItemItem) {
            // validation for constraint: itemType
            if (!$stockItemForUpdateStockWithAttributesListStockItemItem instanceof \StructType\StockItemForUpdateStockWithAttributes) {
                throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\StockItemForUpdateStockWithAttributes, "%s" given', is_object($stockItemForUpdateStockWithAttributesListStockItemItem) ? get_class($stockItemForUpdateStockWithAttributesListStockItemItem) : gettype($stockItemForUpdateStockWithAttributesListStockItemItem)), __LINE__);
            }
        }
        $this->stockItem = $stockItem;
        return $this;
    }
    /**
     * Add item to stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemForUpdateStockWithAttributes $item
     * @return \StructType\StockItemForUpdateStockWithAttributesList
     */
    public function addToStockItem(\StructType\StockItemForUpdateStockWithAttributes $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockItemForUpdateStockWithAttributes) {
            throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\StockItemForUpdateStockWithAttributes, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockItemForUpdateStockWithAttributesList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
