<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockItemForUpdateStockWithAttributes StructType
 * @subpackage Structs
 */
class StockItemForUpdateStockWithAttributes extends AbstractStructBase
{
    /**
     * The attributes
     * @var \StructType\StockAttributeList
     */
    public $attributes;
    /**
     * The quantity
     * @var int
     */
    public $quantity;
    /**
     * The version
     * @var int
     */
    public $version;
    /**
     * Constructor method for StockItemForUpdateStockWithAttributes
     * @uses StockItemForUpdateStockWithAttributes::setAttributes()
     * @uses StockItemForUpdateStockWithAttributes::setQuantity()
     * @uses StockItemForUpdateStockWithAttributes::setVersion()
     * @param \StructType\StockAttributeList $attributes
     * @param int $quantity
     * @param int $version
     */
    public function __construct(\StructType\StockAttributeList $attributes = null, $quantity = null, $version = null)
    {
        $this
            ->setAttributes($attributes)
            ->setQuantity($quantity)
            ->setVersion($version);
    }
    /**
     * Get attributes value
     * @return \StructType\StockAttributeList|null
     */
    public function getAttributes()
    {
        return $this->attributes;
    }
    /**
     * Set attributes value
     * @param \StructType\StockAttributeList $attributes
     * @return \StructType\StockItemForUpdateStockWithAttributes
     */
    public function setAttributes(\StructType\StockAttributeList $attributes = null)
    {
        $this->attributes = $attributes;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\StockItemForUpdateStockWithAttributes
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get version value
     * @return int|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param int $version
     * @return \StructType\StockItemForUpdateStockWithAttributes
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !is_numeric($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockItemForUpdateStockWithAttributes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
