<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockItemForAddStockWithSellerStockCodeList StructType
 * @subpackage Structs
 */
class StockItemForAddStockWithSellerStockCodeList extends AbstractStructBase
{
    /**
     * The stockItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\StockItemForAddStockWithSellerStockCode[]
     */
    public $stockItem;
    /**
     * Constructor method for StockItemForAddStockWithSellerStockCodeList
     * @uses StockItemForAddStockWithSellerStockCodeList::setStockItem()
     * @param \StructType\StockItemForAddStockWithSellerStockCode[] $stockItem
     */
    public function __construct(array $stockItem = array())
    {
        $this
            ->setStockItem($stockItem);
    }
    /**
     * Get stockItem value
     * @return \StructType\StockItemForAddStockWithSellerStockCode[]|null
     */
    public function getStockItem()
    {
        return $this->stockItem;
    }
    /**
     * Set stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemForAddStockWithSellerStockCode[] $stockItem
     * @return \StructType\StockItemForAddStockWithSellerStockCodeList
     */
    public function setStockItem(array $stockItem = array())
    {
        foreach ($stockItem as $stockItemForAddStockWithSellerStockCodeListStockItemItem) {
            // validation for constraint: itemType
            if (!$stockItemForAddStockWithSellerStockCodeListStockItemItem instanceof \StructType\StockItemForAddStockWithSellerStockCode) {
                throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\StockItemForAddStockWithSellerStockCode, "%s" given', is_object($stockItemForAddStockWithSellerStockCodeListStockItemItem) ? get_class($stockItemForAddStockWithSellerStockCodeListStockItemItem) : gettype($stockItemForAddStockWithSellerStockCodeListStockItemItem)), __LINE__);
            }
        }
        $this->stockItem = $stockItem;
        return $this;
    }
    /**
     * Add item to stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\StockItemForAddStockWithSellerStockCode $item
     * @return \StructType\StockItemForAddStockWithSellerStockCodeList
     */
    public function addToStockItem(\StructType\StockItemForAddStockWithSellerStockCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockItemForAddStockWithSellerStockCode) {
            throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\StockItemForAddStockWithSellerStockCode, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockItemForAddStockWithSellerStockCodeList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
