<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockAttributeList StructType
 * @subpackage Structs
 */
class StockAttributeList extends AbstractStructBase
{
    /**
     * The attribute
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\StockAttribute[]
     */
    public $attribute;
    /**
     * Constructor method for StockAttributeList
     * @uses StockAttributeList::setAttribute()
     * @param \StructType\StockAttribute[] $attribute
     */
    public function __construct(array $attribute = array())
    {
        $this
            ->setAttribute($attribute);
    }
    /**
     * Get attribute value
     * @return \StructType\StockAttribute[]|null
     */
    public function getAttribute()
    {
        return $this->attribute;
    }
    /**
     * Set attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\StockAttribute[] $attribute
     * @return \StructType\StockAttributeList
     */
    public function setAttribute(array $attribute = array())
    {
        foreach ($attribute as $stockAttributeListAttributeItem) {
            // validation for constraint: itemType
            if (!$stockAttributeListAttributeItem instanceof \StructType\StockAttribute) {
                throw new \InvalidArgumentException(sprintf('The attribute property can only contain items of \StructType\StockAttribute, "%s" given', is_object($stockAttributeListAttributeItem) ? get_class($stockAttributeListAttributeItem) : gettype($stockAttributeListAttributeItem)), __LINE__);
            }
        }
        $this->attribute = $attribute;
        return $this;
    }
    /**
     * Add item to attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\StockAttribute $item
     * @return \StructType\StockAttributeList
     */
    public function addToAttribute(\StructType\StockAttribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockAttribute) {
            throw new \InvalidArgumentException(sprintf('The attribute property can only contain items of \StructType\StockAttribute, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attribute[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockAttributeList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
