<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialProductInfoList StructType
 * @subpackage Structs
 */
class SpecialProductInfoList extends AbstractStructBase
{
    /**
     * The specialProductInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\SpecialProductInfoApiModel[]
     */
    public $specialProductInfo;
    /**
     * Constructor method for SpecialProductInfoList
     * @uses SpecialProductInfoList::setSpecialProductInfo()
     * @param \StructType\SpecialProductInfoApiModel[] $specialProductInfo
     */
    public function __construct(array $specialProductInfo = array())
    {
        $this
            ->setSpecialProductInfo($specialProductInfo);
    }
    /**
     * Get specialProductInfo value
     * @return \StructType\SpecialProductInfoApiModel[]|null
     */
    public function getSpecialProductInfo()
    {
        return $this->specialProductInfo;
    }
    /**
     * Set specialProductInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialProductInfoApiModel[] $specialProductInfo
     * @return \StructType\SpecialProductInfoList
     */
    public function setSpecialProductInfo(array $specialProductInfo = array())
    {
        foreach ($specialProductInfo as $specialProductInfoListSpecialProductInfoItem) {
            // validation for constraint: itemType
            if (!$specialProductInfoListSpecialProductInfoItem instanceof \StructType\SpecialProductInfoApiModel) {
                throw new \InvalidArgumentException(sprintf('The specialProductInfo property can only contain items of \StructType\SpecialProductInfoApiModel, "%s" given', is_object($specialProductInfoListSpecialProductInfoItem) ? get_class($specialProductInfoListSpecialProductInfoItem) : gettype($specialProductInfoListSpecialProductInfoItem)), __LINE__);
            }
        }
        $this->specialProductInfo = $specialProductInfo;
        return $this;
    }
    /**
     * Add item to specialProductInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialProductInfoApiModel $item
     * @return \StructType\SpecialProductInfoList
     */
    public function addToSpecialProductInfo(\StructType\SpecialProductInfoApiModel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecialProductInfoApiModel) {
            throw new \InvalidArgumentException(sprintf('The specialProductInfo property can only contain items of \StructType\SpecialProductInfoApiModel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->specialProductInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpecialProductInfoList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
