<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaveProductAnswerRequest StructType
 * @subpackage Structs
 */
class SaveProductAnswerRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The productQuestionId
     * @var int
     */
    public $productQuestionId;
    /**
     * The answer
     * @var string
     */
    public $answer;
    /**
     * Constructor method for SaveProductAnswerRequest
     * @uses SaveProductAnswerRequest::setAuth()
     * @uses SaveProductAnswerRequest::setProductQuestionId()
     * @uses SaveProductAnswerRequest::setAnswer()
     * @param \StructType\Authentication $auth
     * @param int $productQuestionId
     * @param string $answer
     */
    public function __construct(\StructType\Authentication $auth = null, $productQuestionId = null, $answer = null)
    {
        $this
            ->setAuth($auth)
            ->setProductQuestionId($productQuestionId)
            ->setAnswer($answer);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\SaveProductAnswerRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get productQuestionId value
     * @return int|null
     */
    public function getProductQuestionId()
    {
        return $this->productQuestionId;
    }
    /**
     * Set productQuestionId value
     * @param int $productQuestionId
     * @return \StructType\SaveProductAnswerRequest
     */
    public function setProductQuestionId($productQuestionId = null)
    {
        // validation for constraint: int
        if (!is_null($productQuestionId) && !is_numeric($productQuestionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productQuestionId)), __LINE__);
        }
        $this->productQuestionId = $productQuestionId;
        return $this;
    }
    /**
     * Get answer value
     * @return string|null
     */
    public function getAnswer()
    {
        return $this->answer;
    }
    /**
     * Set answer value
     * @param string $answer
     * @return \StructType\SaveProductAnswerRequest
     */
    public function setAnswer($answer = null)
    {
        // validation for constraint: string
        if (!is_null($answer) && !is_string($answer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($answer)), __LINE__);
        }
        $this->answer = $answer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SaveProductAnswerRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
