<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductUpdateSkuBasicRequestItemList StructType
 * @subpackage Structs
 */
class ProductUpdateSkuBasicRequestItemList extends AbstractStructBase
{
    /**
     * The stockItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProductUpdateSkuBasicRequest[]
     */
    public $stockItem;
    /**
     * Constructor method for ProductUpdateSkuBasicRequestItemList
     * @uses ProductUpdateSkuBasicRequestItemList::setStockItem()
     * @param \StructType\ProductUpdateSkuBasicRequest[] $stockItem
     */
    public function __construct(array $stockItem = array())
    {
        $this
            ->setStockItem($stockItem);
    }
    /**
     * Get stockItem value
     * @return \StructType\ProductUpdateSkuBasicRequest[]|null
     */
    public function getStockItem()
    {
        return $this->stockItem;
    }
    /**
     * Set stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductUpdateSkuBasicRequest[] $stockItem
     * @return \StructType\ProductUpdateSkuBasicRequestItemList
     */
    public function setStockItem(array $stockItem = array())
    {
        foreach ($stockItem as $productUpdateSkuBasicRequestItemListStockItemItem) {
            // validation for constraint: itemType
            if (!$productUpdateSkuBasicRequestItemListStockItemItem instanceof \StructType\ProductUpdateSkuBasicRequest) {
                throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\ProductUpdateSkuBasicRequest, "%s" given', is_object($productUpdateSkuBasicRequestItemListStockItemItem) ? get_class($productUpdateSkuBasicRequestItemListStockItemItem) : gettype($productUpdateSkuBasicRequestItemListStockItemItem)), __LINE__);
            }
        }
        $this->stockItem = $stockItem;
        return $this;
    }
    /**
     * Add item to stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductUpdateSkuBasicRequest $item
     * @return \StructType\ProductUpdateSkuBasicRequestItemList
     */
    public function addToStockItem(\StructType\ProductUpdateSkuBasicRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductUpdateSkuBasicRequest) {
            throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\ProductUpdateSkuBasicRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductUpdateSkuBasicRequestItemList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
