<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductUpdateSkuBasicRequest StructType
 * @subpackage Structs
 */
class ProductUpdateSkuBasicRequest extends AbstractStructBase
{
    /**
     * The sellerStockCode
     * @var string
     */
    public $sellerStockCode;
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The optionPrice
     * @var float
     */
    public $optionPrice;
    /**
     * The quantity
     * @var int
     */
    public $quantity;
    /**
     * Constructor method for ProductUpdateSkuBasicRequest
     * @uses ProductUpdateSkuBasicRequest::setSellerStockCode()
     * @uses ProductUpdateSkuBasicRequest::setId()
     * @uses ProductUpdateSkuBasicRequest::setOptionPrice()
     * @uses ProductUpdateSkuBasicRequest::setQuantity()
     * @param string $sellerStockCode
     * @param int $id
     * @param float $optionPrice
     * @param int $quantity
     */
    public function __construct($sellerStockCode = null, $id = null, $optionPrice = null, $quantity = null)
    {
        $this
            ->setSellerStockCode($sellerStockCode)
            ->setId($id)
            ->setOptionPrice($optionPrice)
            ->setQuantity($quantity);
    }
    /**
     * Get sellerStockCode value
     * @return string|null
     */
    public function getSellerStockCode()
    {
        return $this->sellerStockCode;
    }
    /**
     * Set sellerStockCode value
     * @param string $sellerStockCode
     * @return \StructType\ProductUpdateSkuBasicRequest
     */
    public function setSellerStockCode($sellerStockCode = null)
    {
        // validation for constraint: string
        if (!is_null($sellerStockCode) && !is_string($sellerStockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sellerStockCode)), __LINE__);
        }
        $this->sellerStockCode = $sellerStockCode;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\ProductUpdateSkuBasicRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get optionPrice value
     * @return float|null
     */
    public function getOptionPrice()
    {
        return $this->optionPrice;
    }
    /**
     * Set optionPrice value
     * @param float $optionPrice
     * @return \StructType\ProductUpdateSkuBasicRequest
     */
    public function setOptionPrice($optionPrice = null)
    {
        $this->optionPrice = $optionPrice;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\ProductUpdateSkuBasicRequest
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductUpdateSkuBasicRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
