<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSkuRequest StructType
 * @subpackage Structs
 */
class ProductSkuRequest extends AbstractStructBase
{
    /**
     * The bundle
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $bundle;
    /**
     * The mpn
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $mpn;
    /**
     * The gtin
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $gtin;
    /**
     * The oem
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $oem;
    /**
     * The quantity
     * @var int
     */
    public $quantity;
    /**
     * The sellerStockCode
     * @var string
     */
    public $sellerStockCode;
    /**
     * The attributes
     * @var \StructType\ProductAttributeRequestList
     */
    public $attributes;
    /**
     * The optionPrice
     * @var float
     */
    public $optionPrice;
    /**
     * Constructor method for ProductSkuRequest
     * @uses ProductSkuRequest::setBundle()
     * @uses ProductSkuRequest::setMpn()
     * @uses ProductSkuRequest::setGtin()
     * @uses ProductSkuRequest::setOem()
     * @uses ProductSkuRequest::setQuantity()
     * @uses ProductSkuRequest::setSellerStockCode()
     * @uses ProductSkuRequest::setAttributes()
     * @uses ProductSkuRequest::setOptionPrice()
     * @param bool $bundle
     * @param string $mpn
     * @param string $gtin
     * @param string $oem
     * @param int $quantity
     * @param string $sellerStockCode
     * @param \StructType\ProductAttributeRequestList $attributes
     * @param float $optionPrice
     */
    public function __construct($bundle = null, $mpn = null, $gtin = null, $oem = null, $quantity = null, $sellerStockCode = null, \StructType\ProductAttributeRequestList $attributes = null, $optionPrice = null)
    {
        $this
            ->setBundle($bundle)
            ->setMpn($mpn)
            ->setGtin($gtin)
            ->setOem($oem)
            ->setQuantity($quantity)
            ->setSellerStockCode($sellerStockCode)
            ->setAttributes($attributes)
            ->setOptionPrice($optionPrice);
    }
    /**
     * Get bundle value
     * @return bool|null
     */
    public function getBundle()
    {
        return $this->bundle;
    }
    /**
     * Set bundle value
     * @param bool $bundle
     * @return \StructType\ProductSkuRequest
     */
    public function setBundle($bundle = null)
    {
        // validation for constraint: boolean
        if (!is_null($bundle) && !is_bool($bundle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($bundle)), __LINE__);
        }
        $this->bundle = $bundle;
        return $this;
    }
    /**
     * Get mpn value
     * @return string|null
     */
    public function getMpn()
    {
        return $this->mpn;
    }
    /**
     * Set mpn value
     * @param string $mpn
     * @return \StructType\ProductSkuRequest
     */
    public function setMpn($mpn = null)
    {
        // validation for constraint: string
        if (!is_null($mpn) && !is_string($mpn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mpn)), __LINE__);
        }
        $this->mpn = $mpn;
        return $this;
    }
    /**
     * Get gtin value
     * @return string|null
     */
    public function getGtin()
    {
        return $this->gtin;
    }
    /**
     * Set gtin value
     * @param string $gtin
     * @return \StructType\ProductSkuRequest
     */
    public function setGtin($gtin = null)
    {
        // validation for constraint: string
        if (!is_null($gtin) && !is_string($gtin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gtin)), __LINE__);
        }
        $this->gtin = $gtin;
        return $this;
    }
    /**
     * Get oem value
     * @return string|null
     */
    public function getOem()
    {
        return $this->oem;
    }
    /**
     * Set oem value
     * @param string $oem
     * @return \StructType\ProductSkuRequest
     */
    public function setOem($oem = null)
    {
        // validation for constraint: string
        if (!is_null($oem) && !is_string($oem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oem)), __LINE__);
        }
        $this->oem = $oem;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\ProductSkuRequest
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get sellerStockCode value
     * @return string|null
     */
    public function getSellerStockCode()
    {
        return $this->sellerStockCode;
    }
    /**
     * Set sellerStockCode value
     * @param string $sellerStockCode
     * @return \StructType\ProductSkuRequest
     */
    public function setSellerStockCode($sellerStockCode = null)
    {
        // validation for constraint: string
        if (!is_null($sellerStockCode) && !is_string($sellerStockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sellerStockCode)), __LINE__);
        }
        $this->sellerStockCode = $sellerStockCode;
        return $this;
    }
    /**
     * Get attributes value
     * @return \StructType\ProductAttributeRequestList|null
     */
    public function getAttributes()
    {
        return $this->attributes;
    }
    /**
     * Set attributes value
     * @param \StructType\ProductAttributeRequestList $attributes
     * @return \StructType\ProductSkuRequest
     */
    public function setAttributes(\StructType\ProductAttributeRequestList $attributes = null)
    {
        $this->attributes = $attributes;
        return $this;
    }
    /**
     * Get optionPrice value
     * @return float|null
     */
    public function getOptionPrice()
    {
        return $this->optionPrice;
    }
    /**
     * Set optionPrice value
     * @param float $optionPrice
     * @return \StructType\ProductSkuRequest
     */
    public function setOptionPrice($optionPrice = null)
    {
        $this->optionPrice = $optionPrice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductSkuRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
