<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSkuList StructType
 * @subpackage Structs
 */
class ProductSkuList extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The stockItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProductSku[]
     */
    public $stockItem;
    /**
     * The productSellerCode
     * @var string
     */
    public $productSellerCode;
    /**
     * Constructor method for ProductSkuList
     * @uses ProductSkuList::setId()
     * @uses ProductSkuList::setStockItem()
     * @uses ProductSkuList::setProductSellerCode()
     * @param int $id
     * @param \StructType\ProductSku[] $stockItem
     * @param string $productSellerCode
     */
    public function __construct($id = null, array $stockItem = array(), $productSellerCode = null)
    {
        $this
            ->setId($id)
            ->setStockItem($stockItem)
            ->setProductSellerCode($productSellerCode);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\ProductSkuList
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get stockItem value
     * @return \StructType\ProductSku[]|null
     */
    public function getStockItem()
    {
        return $this->stockItem;
    }
    /**
     * Set stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductSku[] $stockItem
     * @return \StructType\ProductSkuList
     */
    public function setStockItem(array $stockItem = array())
    {
        foreach ($stockItem as $productSkuListStockItemItem) {
            // validation for constraint: itemType
            if (!$productSkuListStockItemItem instanceof \StructType\ProductSku) {
                throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\ProductSku, "%s" given', is_object($productSkuListStockItemItem) ? get_class($productSkuListStockItemItem) : gettype($productSkuListStockItemItem)), __LINE__);
            }
        }
        $this->stockItem = $stockItem;
        return $this;
    }
    /**
     * Add item to stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductSku $item
     * @return \StructType\ProductSkuList
     */
    public function addToStockItem(\StructType\ProductSku $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductSku) {
            throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\ProductSku, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockItem[] = $item;
        return $this;
    }
    /**
     * Get productSellerCode value
     * @return string|null
     */
    public function getProductSellerCode()
    {
        return $this->productSellerCode;
    }
    /**
     * Set productSellerCode value
     * @param string $productSellerCode
     * @return \StructType\ProductSkuList
     */
    public function setProductSellerCode($productSellerCode = null)
    {
        // validation for constraint: string
        if (!is_null($productSellerCode) && !is_string($productSellerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productSellerCode)), __LINE__);
        }
        $this->productSellerCode = $productSellerCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductSkuList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
