<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSkuItemList StructType
 * @subpackage Structs
 */
class ProductSkuItemList extends AbstractStructBase
{
    /**
     * The stockItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProductSku[]
     */
    public $stockItem;
    /**
     * Constructor method for ProductSkuItemList
     * @uses ProductSkuItemList::setStockItem()
     * @param \StructType\ProductSku[] $stockItem
     */
    public function __construct(array $stockItem = array())
    {
        $this
            ->setStockItem($stockItem);
    }
    /**
     * Get stockItem value
     * @return \StructType\ProductSku[]|null
     */
    public function getStockItem()
    {
        return $this->stockItem;
    }
    /**
     * Set stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductSku[] $stockItem
     * @return \StructType\ProductSkuItemList
     */
    public function setStockItem(array $stockItem = array())
    {
        foreach ($stockItem as $productSkuItemListStockItemItem) {
            // validation for constraint: itemType
            if (!$productSkuItemListStockItemItem instanceof \StructType\ProductSku) {
                throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\ProductSku, "%s" given', is_object($productSkuItemListStockItemItem) ? get_class($productSkuItemListStockItemItem) : gettype($productSkuItemListStockItemItem)), __LINE__);
            }
        }
        $this->stockItem = $stockItem;
        return $this;
    }
    /**
     * Add item to stockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductSku $item
     * @return \StructType\ProductSkuItemList
     */
    public function addToStockItem(\StructType\ProductSku $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductSku) {
            throw new \InvalidArgumentException(sprintf('The stockItem property can only contain items of \StructType\ProductSku, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductSkuItemList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
