<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSkuBasicRequest StructType
 * @subpackage Structs
 */
class ProductSkuBasicRequest extends AbstractStructBase
{
    /**
     * The sellerStockCode
     * @var string
     */
    public $sellerStockCode;
    /**
     * The optionPrice
     * @var float
     */
    public $optionPrice;
    /**
     * Constructor method for ProductSkuBasicRequest
     * @uses ProductSkuBasicRequest::setSellerStockCode()
     * @uses ProductSkuBasicRequest::setOptionPrice()
     * @param string $sellerStockCode
     * @param float $optionPrice
     */
    public function __construct($sellerStockCode = null, $optionPrice = null)
    {
        $this
            ->setSellerStockCode($sellerStockCode)
            ->setOptionPrice($optionPrice);
    }
    /**
     * Get sellerStockCode value
     * @return string|null
     */
    public function getSellerStockCode()
    {
        return $this->sellerStockCode;
    }
    /**
     * Set sellerStockCode value
     * @param string $sellerStockCode
     * @return \StructType\ProductSkuBasicRequest
     */
    public function setSellerStockCode($sellerStockCode = null)
    {
        // validation for constraint: string
        if (!is_null($sellerStockCode) && !is_string($sellerStockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sellerStockCode)), __LINE__);
        }
        $this->sellerStockCode = $sellerStockCode;
        return $this;
    }
    /**
     * Get optionPrice value
     * @return float|null
     */
    public function getOptionPrice()
    {
        return $this->optionPrice;
    }
    /**
     * Set optionPrice value
     * @param float $optionPrice
     * @return \StructType\ProductSkuBasicRequest
     */
    public function setOptionPrice($optionPrice = null)
    {
        $this->optionPrice = $optionPrice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductSkuBasicRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
