<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSku StructType
 * @subpackage Structs
 */
class ProductSku extends ProductSkuBasic
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The version
     * @var int
     */
    public $version;
    /**
     * The quantity
     * @var int
     */
    public $quantity;
    /**
     * The attributes
     * @var \StructType\ProductAttributeList
     */
    public $attributes;
    /**
     * Constructor method for ProductSku
     * @uses ProductSku::setId()
     * @uses ProductSku::setVersion()
     * @uses ProductSku::setQuantity()
     * @uses ProductSku::setAttributes()
     * @param int $id
     * @param int $version
     * @param int $quantity
     * @param \StructType\ProductAttributeList $attributes
     */
    public function __construct($id = null, $version = null, $quantity = null, \StructType\ProductAttributeList $attributes = null)
    {
        $this
            ->setId($id)
            ->setVersion($version)
            ->setQuantity($quantity)
            ->setAttributes($attributes);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\ProductSku
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get version value
     * @return int|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param int $version
     * @return \StructType\ProductSku
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !is_numeric($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\ProductSku
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get attributes value
     * @return \StructType\ProductAttributeList|null
     */
    public function getAttributes()
    {
        return $this->attributes;
    }
    /**
     * Set attributes value
     * @param \StructType\ProductAttributeList $attributes
     * @return \StructType\ProductSku
     */
    public function setAttributes(\StructType\ProductAttributeList $attributes = null)
    {
        $this->attributes = $attributes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductSku
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
