<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSearch StructType
 * @subpackage Structs
 */
class ProductSearch extends AbstractStructBase
{
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The saleDate
     * @var \StructType\DateRange
     */
    public $saleDate;
    /**
     * The approvalStatus
     * @var string
     */
    public $approvalStatus;
    /**
     * The bundle
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $bundle;
    /**
     * The mpn
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $mpn;
    /**
     * The gtin
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $gtin;
    /**
     * The oem
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $oem;
    /**
     * Constructor method for ProductSearch
     * @uses ProductSearch::setName()
     * @uses ProductSearch::setSaleDate()
     * @uses ProductSearch::setApprovalStatus()
     * @uses ProductSearch::setBundle()
     * @uses ProductSearch::setMpn()
     * @uses ProductSearch::setGtin()
     * @uses ProductSearch::setOem()
     * @param string $name
     * @param \StructType\DateRange $saleDate
     * @param string $approvalStatus
     * @param bool $bundle
     * @param string $mpn
     * @param string $gtin
     * @param string $oem
     */
    public function __construct($name = null, \StructType\DateRange $saleDate = null, $approvalStatus = null, $bundle = null, $mpn = null, $gtin = null, $oem = null)
    {
        $this
            ->setName($name)
            ->setSaleDate($saleDate)
            ->setApprovalStatus($approvalStatus)
            ->setBundle($bundle)
            ->setMpn($mpn)
            ->setGtin($gtin)
            ->setOem($oem);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ProductSearch
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get saleDate value
     * @return \StructType\DateRange|null
     */
    public function getSaleDate()
    {
        return $this->saleDate;
    }
    /**
     * Set saleDate value
     * @param \StructType\DateRange $saleDate
     * @return \StructType\ProductSearch
     */
    public function setSaleDate(\StructType\DateRange $saleDate = null)
    {
        $this->saleDate = $saleDate;
        return $this;
    }
    /**
     * Get approvalStatus value
     * @return string|null
     */
    public function getApprovalStatus()
    {
        return $this->approvalStatus;
    }
    /**
     * Set approvalStatus value
     * @uses \EnumType\ProductStatus::valueIsValid()
     * @uses \EnumType\ProductStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $approvalStatus
     * @return \StructType\ProductSearch
     */
    public function setApprovalStatus($approvalStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductStatus::valueIsValid($approvalStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $approvalStatus, implode(', ', \EnumType\ProductStatus::getValidValues())), __LINE__);
        }
        $this->approvalStatus = $approvalStatus;
        return $this;
    }
    /**
     * Get bundle value
     * @return bool|null
     */
    public function getBundle()
    {
        return $this->bundle;
    }
    /**
     * Set bundle value
     * @param bool $bundle
     * @return \StructType\ProductSearch
     */
    public function setBundle($bundle = null)
    {
        // validation for constraint: boolean
        if (!is_null($bundle) && !is_bool($bundle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($bundle)), __LINE__);
        }
        $this->bundle = $bundle;
        return $this;
    }
    /**
     * Get mpn value
     * @return string|null
     */
    public function getMpn()
    {
        return $this->mpn;
    }
    /**
     * Set mpn value
     * @param string $mpn
     * @return \StructType\ProductSearch
     */
    public function setMpn($mpn = null)
    {
        // validation for constraint: string
        if (!is_null($mpn) && !is_string($mpn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mpn)), __LINE__);
        }
        $this->mpn = $mpn;
        return $this;
    }
    /**
     * Get gtin value
     * @return string|null
     */
    public function getGtin()
    {
        return $this->gtin;
    }
    /**
     * Set gtin value
     * @param string $gtin
     * @return \StructType\ProductSearch
     */
    public function setGtin($gtin = null)
    {
        // validation for constraint: string
        if (!is_null($gtin) && !is_string($gtin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gtin)), __LINE__);
        }
        $this->gtin = $gtin;
        return $this;
    }
    /**
     * Get oem value
     * @return string|null
     */
    public function getOem()
    {
        return $this->oem;
    }
    /**
     * Set oem value
     * @param string $oem
     * @return \StructType\ProductSearch
     */
    public function setOem($oem = null)
    {
        // validation for constraint: string
        if (!is_null($oem) && !is_string($oem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oem)), __LINE__);
        }
        $this->oem = $oem;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductSearch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
