<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductQuestionSearch StructType
 * @subpackage Structs
 */
class ProductQuestionSearch extends AbstractStructBase
{
    /**
     * The productId
     * @var int
     */
    public $productId;
    /**
     * The buyerEmail
     * @var string
     */
    public $buyerEmail;
    /**
     * The subject
     * @var string
     */
    public $subject;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The questionDate
     * @var string
     */
    public $questionDate;
    /**
     * Constructor method for ProductQuestionSearch
     * @uses ProductQuestionSearch::setProductId()
     * @uses ProductQuestionSearch::setBuyerEmail()
     * @uses ProductQuestionSearch::setSubject()
     * @uses ProductQuestionSearch::setStatus()
     * @uses ProductQuestionSearch::setQuestionDate()
     * @param int $productId
     * @param string $buyerEmail
     * @param string $subject
     * @param string $status
     * @param string $questionDate
     */
    public function __construct($productId = null, $buyerEmail = null, $subject = null, $status = null, $questionDate = null)
    {
        $this
            ->setProductId($productId)
            ->setBuyerEmail($buyerEmail)
            ->setSubject($subject)
            ->setStatus($status)
            ->setQuestionDate($questionDate);
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\ProductQuestionSearch
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !is_numeric($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get buyerEmail value
     * @return string|null
     */
    public function getBuyerEmail()
    {
        return $this->buyerEmail;
    }
    /**
     * Set buyerEmail value
     * @param string $buyerEmail
     * @return \StructType\ProductQuestionSearch
     */
    public function setBuyerEmail($buyerEmail = null)
    {
        // validation for constraint: string
        if (!is_null($buyerEmail) && !is_string($buyerEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($buyerEmail)), __LINE__);
        }
        $this->buyerEmail = $buyerEmail;
        return $this;
    }
    /**
     * Get subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->subject;
    }
    /**
     * Set subject value
     * @param string $subject
     * @return \StructType\ProductQuestionSearch
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subject)), __LINE__);
        }
        $this->subject = $subject;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\ProductQuestionStatus::valueIsValid()
     * @uses \EnumType\ProductQuestionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\ProductQuestionSearch
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductQuestionStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\ProductQuestionStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get questionDate value
     * @return string|null
     */
    public function getQuestionDate()
    {
        return $this->questionDate;
    }
    /**
     * Set questionDate value
     * @param string $questionDate
     * @return \StructType\ProductQuestionSearch
     */
    public function setQuestionDate($questionDate = null)
    {
        // validation for constraint: string
        if (!is_null($questionDate) && !is_string($questionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($questionDate)), __LINE__);
        }
        $this->questionDate = $questionDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductQuestionSearch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
