<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductQuestionList StructType
 * @subpackage Structs
 */
class ProductQuestionList extends AbstractStructBase
{
    /**
     * The productQuestion
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProductQuestion[]
     */
    public $productQuestion;
    /**
     * Constructor method for ProductQuestionList
     * @uses ProductQuestionList::setProductQuestion()
     * @param \StructType\ProductQuestion[] $productQuestion
     */
    public function __construct(array $productQuestion = array())
    {
        $this
            ->setProductQuestion($productQuestion);
    }
    /**
     * Get productQuestion value
     * @return \StructType\ProductQuestion[]|null
     */
    public function getProductQuestion()
    {
        return $this->productQuestion;
    }
    /**
     * Set productQuestion value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductQuestion[] $productQuestion
     * @return \StructType\ProductQuestionList
     */
    public function setProductQuestion(array $productQuestion = array())
    {
        foreach ($productQuestion as $productQuestionListProductQuestionItem) {
            // validation for constraint: itemType
            if (!$productQuestionListProductQuestionItem instanceof \StructType\ProductQuestion) {
                throw new \InvalidArgumentException(sprintf('The productQuestion property can only contain items of \StructType\ProductQuestion, "%s" given', is_object($productQuestionListProductQuestionItem) ? get_class($productQuestionListProductQuestionItem) : gettype($productQuestionListProductQuestionItem)), __LINE__);
            }
        }
        $this->productQuestion = $productQuestion;
        return $this;
    }
    /**
     * Add item to productQuestion value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductQuestion $item
     * @return \StructType\ProductQuestionList
     */
    public function addToProductQuestion(\StructType\ProductQuestion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductQuestion) {
            throw new \InvalidArgumentException(sprintf('The productQuestion property can only contain items of \StructType\ProductQuestion, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->productQuestion[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductQuestionList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
