<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductBasicList StructType
 * @subpackage Structs
 */
class ProductBasicList extends AbstractStructBase
{
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProductBasic[]
     */
    public $product;
    /**
     * Constructor method for ProductBasicList
     * @uses ProductBasicList::setProduct()
     * @param \StructType\ProductBasic[] $product
     */
    public function __construct(array $product = array())
    {
        $this
            ->setProduct($product);
    }
    /**
     * Get product value
     * @return \StructType\ProductBasic[]|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductBasic[] $product
     * @return \StructType\ProductBasicList
     */
    public function setProduct(array $product = array())
    {
        foreach ($product as $productBasicListProductItem) {
            // validation for constraint: itemType
            if (!$productBasicListProductItem instanceof \StructType\ProductBasic) {
                throw new \InvalidArgumentException(sprintf('The product property can only contain items of \StructType\ProductBasic, "%s" given', is_object($productBasicListProductItem) ? get_class($productBasicListProductItem) : gettype($productBasicListProductItem)), __LINE__);
            }
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Add item to product value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductBasic $item
     * @return \StructType\ProductBasicList
     */
    public function addToProduct(\StructType\ProductBasic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductBasic) {
            throw new \InvalidArgumentException(sprintf('The product property can only contain items of \StructType\ProductBasic, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->product[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductBasicList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
