<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductAttributeRequestList StructType
 * @subpackage Structs
 */
class ProductAttributeRequestList extends AbstractStructBase
{
    /**
     * The attribute
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ProductAttributeRequest[]
     */
    public $attribute;
    /**
     * Constructor method for ProductAttributeRequestList
     * @uses ProductAttributeRequestList::setAttribute()
     * @param \StructType\ProductAttributeRequest[] $attribute
     */
    public function __construct(array $attribute = array())
    {
        $this
            ->setAttribute($attribute);
    }
    /**
     * Get attribute value
     * @return \StructType\ProductAttributeRequest[]|null
     */
    public function getAttribute()
    {
        return $this->attribute;
    }
    /**
     * Set attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductAttributeRequest[] $attribute
     * @return \StructType\ProductAttributeRequestList
     */
    public function setAttribute(array $attribute = array())
    {
        foreach ($attribute as $productAttributeRequestListAttributeItem) {
            // validation for constraint: itemType
            if (!$productAttributeRequestListAttributeItem instanceof \StructType\ProductAttributeRequest) {
                throw new \InvalidArgumentException(sprintf('The attribute property can only contain items of \StructType\ProductAttributeRequest, "%s" given', is_object($productAttributeRequestListAttributeItem) ? get_class($productAttributeRequestListAttributeItem) : gettype($productAttributeRequestListAttributeItem)), __LINE__);
            }
        }
        $this->attribute = $attribute;
        return $this;
    }
    /**
     * Add item to attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductAttributeRequest $item
     * @return \StructType\ProductAttributeRequestList
     */
    public function addToAttribute(\StructType\ProductAttributeRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductAttributeRequest) {
            throw new \InvalidArgumentException(sprintf('The attribute property can only contain items of \StructType\ProductAttributeRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attribute[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductAttributeRequestList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
